/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.geodb;

import org.hibernate.Hibernate;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.CustomType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.geodb.GeoDBGeometryUserType;

public class GeoDBDialect
extends H2Dialect
implements SpatialDialect {
    public GeoDBDialect() {
        this.registerColumnType(2003, "BLOB");
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("GeometryType", (Type)Hibernate.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("ST_SRID", (Type)Hibernate.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("ST_Envelope", (Type)new CustomType((UserType)new GeoDBGeometryUserType(), null)));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("ST_AsText", (Type)Hibernate.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("ST_AsEWKB", (Type)Hibernate.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("ST_IsEmpty", (Type)Hibernate.BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("ST_IsSimple", (Type)Hibernate.BOOLEAN));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("ST_Overlaps", (Type)Hibernate.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("ST_Intersects", (Type)Hibernate.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("ST_Equals", (Type)Hibernate.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("ST_Contains", (Type)Hibernate.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("ST_Crosses", (Type)Hibernate.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("ST_Disjoint", (Type)Hibernate.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("ST_Touches", (Type)Hibernate.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("ST_Within", (Type)Hibernate.BOOLEAN));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("ST_Buffer", (Type)new CustomType((UserType)new GeoDBGeometryUserType(), null)));
        this.registerFunction("dwithin", (SQLFunction)new StandardSQLFunction("ST_DWithin", (Type)StandardBasicTypes.BOOLEAN));
    }

    public UserType getGeometryUserType() {
        return new GeoDBGeometryUserType();
    }

    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            default: 
        }
        throw new IllegalArgumentException("Aggregations of type " + aggregation + " are not supported by this dialect");
    }

    public String getDWithinSQL(String columnName) {
        return "ST_DWithin(" + columnName + ",?,?)";
    }

    public String getHavingSridSQL(String columnName) {
        return "( ST_SRID(" + columnName + ") = ?)";
    }

    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    public String getSpatialFilterExpression(String columnName) {
        return "(" + columnName + " && ? ) ";
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_Within(" + columnName + ", ?)";
            }
            case 6: {
                return " ST_Contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_Crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_Overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_Disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_Intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_Touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_Equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public String getDbGeometryTypeName() {
        return "GEOM";
    }

    public boolean isTwoPhaseFiltering() {
        return false;
    }

    public boolean supportsFiltering() {
        return false;
    }

    public boolean supports(SpatialFunction function) {
        switch (function) {
            case boundary: 
            case convexhull: 
            case difference: 
            case dimension: 
            case distance: 
            case geometrytype: 
            case geomunion: 
            case intersection: 
            case transform: 
            case relate: 
            case symdifference: {
                return false;
            }
        }
        return true;
    }
}

