/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.geodb;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import geodb.GeoDB;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import org.hibernatespatial.AbstractDBGeometryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoDBGeometryUserType
extends AbstractDBGeometryType {
    private static final long serialVersionUID = -8929343431050580222L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoDBGeometryUserType.class);
    private static final int[] geometryTypes = new int[]{2003};
    private GeometryFactory gf = new GeometryFactory();

    public int[] sqlTypes() {
        return geometryTypes;
    }

    public Geometry convert2JTS(Object object) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof Blob) {
                return GeoDB.gFromWKB((byte[])this.toByteArray((Blob)object));
            }
            if (object instanceof Envelope) {
                return this.gf.toGeometry((Envelope)object);
            }
            throw new IllegalArgumentException("Can't convert database object of type " + object.getClass().getCanonicalName());
        }
        catch (Exception e) {
            LOGGER.warn("Could not convert database object to a JTS Geometry.");
            e.printStackTrace();
            return null;
        }
    }

    public Object conv2DBGeometry(Geometry jtsGeom, Connection connection) {
        try {
            return GeoDB.gToWKB((Geometry)jtsGeom);
        }
        catch (Exception e) {
            LOGGER.warn("Could not convert JTS Geometry to a database object.");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(Blob blob) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            int n = 0;
            while ((n = in.read(buf)) >= 0) {
                baos.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not convert database BLOB object to binary stream.");
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Could not close binary stream.");
                e.printStackTrace();
            }
        }
        return baos.toByteArray();
    }
}

