/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.sql.Connection;
import org.hibernatespatial.AbstractDBGeometryType;

public class MySQLGeometryUserType
extends AbstractDBGeometryType {
    private static final int SRIDLEN = 4;
    private final WKBReader reader = new WKBReader();
    private final WKBWriter writer = new WKBWriter(2, 2);
    private static final int[] geometryTypes = new int[]{2003};

    public int[] sqlTypes() {
        return geometryTypes;
    }

    public Geometry convert2JTS(Object object) {
        if (object == null) {
            return null;
        }
        byte[] data = (byte[])object;
        byte[] wkb = new byte[data.length - 4];
        System.arraycopy(data, 4, wkb, 0, wkb.length);
        int srid = 0;
        srid = data[3] << 24 | (data[2] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        Geometry geom = null;
        try {
            geom = this.reader.read(wkb);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't parse incoming MySQL Spatial data.");
        }
        geom.setSRID(srid);
        return geom;
    }

    public Object conv2DBGeometry(Geometry jtsGeom, Connection connection) {
        int srid = jtsGeom.getSRID();
        byte[] wkb = this.writer.write(jtsGeom);
        byte[] byteArr = new byte[wkb.length + 4];
        byteArr[3] = (byte)(srid >> 24 & 0xFF);
        byteArr[2] = (byte)(srid >> 16 & 0xFF);
        byteArr[1] = (byte)(srid >> 8 & 0xFF);
        byteArr[0] = (byte)(srid & 0xFF);
        System.arraycopy(wkb, 0, byteArr, 4, wkb.length);
        return byteArr;
    }
}

