/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.mysql;

import org.hibernate.Hibernate;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.mysql.MySQLGeometryUserType;

public class MySQLSpatialDialect
extends MySQLDialect
implements SpatialDialect {
    public MySQLSpatialDialect() {
        this.registerColumnType(-2, "geometry");
        this.registerFunction("dimension", (SQLFunction)new StandardSQLFunction("dimension", (Type)Hibernate.INTEGER));
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("geometrytype", (Type)Hibernate.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("srid", (Type)Hibernate.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("envelope", (Type)new CustomType(MySQLGeometryUserType.class, null)));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("astext", (Type)Hibernate.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("asbinary", (Type)Hibernate.BINARY));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("overlaps", (Type)Hibernate.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("intersects", (Type)Hibernate.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("equals", (Type)Hibernate.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("contains", (Type)Hibernate.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("crosses", (Type)Hibernate.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("disjoint", (Type)Hibernate.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("touches", (Type)Hibernate.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("within", (Type)Hibernate.BOOLEAN));
        this.registerFunction("relate", (SQLFunction)new StandardSQLFunction("relate", (Type)Hibernate.BOOLEAN));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("distance", (Type)Hibernate.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("buffer", (Type)new CustomType(MySQLGeometryUserType.class, null)));
        this.registerFunction("convexhull", (SQLFunction)new StandardSQLFunction("convexhull", (Type)new CustomType(MySQLGeometryUserType.class, null)));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)new CustomType(MySQLGeometryUserType.class, null)));
        this.registerFunction("intersection", (SQLFunction)new StandardSQLFunction("intersection", (Type)new CustomType(MySQLGeometryUserType.class, null)));
        this.registerFunction("symdifference", (SQLFunction)new StandardSQLFunction("symdifference", (Type)new CustomType(MySQLGeometryUserType.class, null)));
        this.registerFunction("geomunion", (SQLFunction)new StandardSQLFunction("union", (Type)new CustomType(MySQLGeometryUserType.class, null)));
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation, boolean hasFilter) {
        switch (spatialRelation) {
            case 4: {
                return " within(" + columnName + ",?)";
            }
            case 6: {
                return " contains(" + columnName + ", ?)";
            }
            case 3: {
                return " crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " touches(" + columnName + ", ?)";
            }
            case 0: {
                return " equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public String getSpatialFilterExpression(String columnName) {
        return "MBRIntersects(" + columnName + ", ? ) ";
    }

    public UserType getGeometryUserType() {
        return new MySQLGeometryUserType();
    }

    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        throw new UnsupportedOperationException("Mysql has no spatial aggregate SQL functions.");
    }
}

