/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import oracle.jdbc.driver.OracleConnection;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.oracle.ConnectionFinder;

public class DefaultConnectionFinder
implements ConnectionFinder {
    public OracleConnection find(Connection con) throws FinderException {
        if (con == null) {
            return null;
        }
        if (con instanceof OracleConnection) {
            return (OracleConnection)con;
        }
        for (Method method : con.getClass().getMethods()) {
            if (!method.getReturnType().isAssignableFrom(Connection.class) || method.getParameterTypes().length != 0) continue;
            try {
                return this.find((Connection)method.invoke((Object)con, new Object[0]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new FinderException("Couldn't get at the OracleSpatial Connection object from the PreparedStatement.");
    }
}

