/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.helper.PropertyFileReader;
import org.hibernatespatial.oracle.ConnectionFinder;
import org.hibernatespatial.oracle.SDOGeometryType;
import org.hibernatespatial.oracle.SDOObjectMethod;
import org.hibernatespatial.oracle.SDOObjectProperty;

public class OracleSpatial10gDialect
extends Oracle9Dialect
implements SpatialDialect {
    public static final String SHORT_NAME = "oraclespatial";
    private static final String CONNECTION_FINDER_PROPERTY = "CONNECTION-FINDER";
    private static final Log log = LogFactory.getLog(OracleSpatial10gDialect.class);
    private String OGC_STRICT = "OGC_STRICT";
    private Map<String, Boolean> features = new HashMap<String, Boolean>();

    public OracleSpatial10gDialect() {
        this.features.put(this.OGC_STRICT, new Boolean(true));
        this.configure();
        this.registerColumnType(2002, "MDSYS.SDO_GEOMETRY");
        this.registerFunction("dimension", new DimensionFunction());
        this.registerFunction("geometrytype", new GetGeometryTypeFunction());
        this.registerFunction("srid", new SDOObjectProperty("SDO_SRID", (Type)Hibernate.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("SDO_GEOM.SDO_MBR", (Type)new CustomType(SDOGeometryType.class, null)));
        this.registerFunction("astext", (SQLFunction)new AsTextFunction());
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("SDO_UTIL.TO_WKBGEOMETRY", (Type)Hibernate.BINARY));
        this.registerFunction("isempty", (SQLFunction)new WrappedOGCFunction("OGC_ISEMPTY", (Type)Hibernate.BOOLEAN, new boolean[]{true}));
        this.registerFunction("issimple", (SQLFunction)new WrappedOGCFunction("OGC_ISSIMPLE", (Type)Hibernate.BOOLEAN, new boolean[]{true}));
        this.registerFunction("boundary", (SQLFunction)new WrappedOGCFunction("OGC_BOUNDARY", (Type)new CustomType(SDOGeometryType.class, null), new boolean[]{true}));
        this.registerFunction("overlaps", (SQLFunction)new SpatialRelateFunction("overlaps", 5));
        this.registerFunction("intersects", (SQLFunction)new SpatialRelateFunction("intersects", 7));
        this.registerFunction("contains", (SQLFunction)new SpatialRelateFunction("intersects", 6));
        this.registerFunction("crosses", (SQLFunction)new SpatialRelateFunction("intersects", 3));
        this.registerFunction("disjoint", (SQLFunction)new SpatialRelateFunction("intersects", 1));
        this.registerFunction("equals", (SQLFunction)new SpatialRelateFunction("intersects", 0));
        this.registerFunction("touches", (SQLFunction)new SpatialRelateFunction("intersects", 2));
        this.registerFunction("within", (SQLFunction)new SpatialRelateFunction("intersects", 4));
        this.registerFunction("relate", (SQLFunction)new WrappedOGCFunction("OGC_RELATE", (Type)Hibernate.BOOLEAN, new boolean[]{true, true, false}));
        this.registerFunction("distance", (SQLFunction)new SpatialAnalysisFunction("distance", (Type)Hibernate.DOUBLE, 1));
        this.registerFunction("buffer", (SQLFunction)new SpatialAnalysisFunction("buffer", (Type)new CustomType(SDOGeometryType.class, null), 2));
        this.registerFunction("convexhull", (SQLFunction)new SpatialAnalysisFunction("convexhull", (Type)new CustomType(SDOGeometryType.class, null), 3));
        this.registerFunction("difference", (SQLFunction)new SpatialAnalysisFunction("difference", (Type)new CustomType(SDOGeometryType.class, null), 6));
        this.registerFunction("intersection", (SQLFunction)new SpatialAnalysisFunction("intersection", (Type)new CustomType(SDOGeometryType.class, null), 4));
        this.registerFunction("symdifference", (SQLFunction)new SpatialAnalysisFunction("symdifference", (Type)new CustomType(SDOGeometryType.class, null), 7));
        this.registerFunction("geomunion", (SQLFunction)new SpatialAnalysisFunction("union", (Type)new CustomType(SDOGeometryType.class, null), 5));
        this.registerFunction("extent", (SQLFunction)new SpatialAggregationFunction("extent", (Type)new CustomType(SDOGeometryType.class, null), false, 1));
        this.registerFunction("centroid", (SQLFunction)new SpatialAggregationFunction("extent", (Type)new CustomType(SDOGeometryType.class, null), false, 101));
        this.registerFunction("concat_lines", (SQLFunction)new SpatialAggregationFunction("extent", (Type)new CustomType(SDOGeometryType.class, null), false, 102));
        this.registerFunction("aggr_convexhull", (SQLFunction)new SpatialAggregationFunction("extent", (Type)new CustomType(SDOGeometryType.class, null), false, 104));
        this.registerFunction("aggr_union", (SQLFunction)new SpatialAggregationFunction("extent", (Type)new CustomType(SDOGeometryType.class, null), false, 103));
        this.registerFunction("lrs_concat", (SQLFunction)new SpatialAggregationFunction("lrsconcat", (Type)new CustomType(SDOGeometryType.class, null), false, 100));
    }

    public UserType getGeometryUserType() {
        return new SDOGeometryType();
    }

    public String getNativeSpatialRelateSQL(String arg1, String arg2, int spatialRelation) {
        String mask = "";
        boolean negate = false;
        switch (spatialRelation) {
            case 7: {
                mask = "ANYINTERACT";
                break;
            }
            case 6: {
                mask = "CONTAINS+COVERS";
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Oracle Spatial does't have equivalent CROSSES relationship");
            }
            case 1: {
                mask = "ANYINTERACT";
                negate = true;
                break;
            }
            case 0: {
                mask = "EQUAL";
                break;
            }
            case 5: {
                mask = "OVERLAPBDYDISJOINT+OVERLAPBDYINTERSECT";
                break;
            }
            case 2: {
                mask = "TOUCH";
                break;
            }
            case 4: {
                mask = "INSIDE+COVEREDBY";
                break;
            }
            default: {
                throw new IllegalArgumentException("undefined SpatialRelation passed (" + spatialRelation + ")");
            }
        }
        StringBuffer buffer = new StringBuffer("CASE SDO_RELATE(");
        buffer.append(arg1);
        buffer.append(",").append(arg2).append(",'mask=" + mask + "')");
        if (!negate) {
            buffer.append(" WHEN 'TRUE' THEN 1 ELSE 0 END");
        } else {
            buffer.append(" WHEN 'TRUE' THEN 0 ELSE 1 END");
        }
        return buffer.toString();
    }

    public String getOGCSpatialRelateSQL(String arg1, String arg2, int spatialRelation) {
        StringBuffer ogcFunction = new StringBuffer("MDSYS.");
        switch (spatialRelation) {
            case 7: {
                ogcFunction.append("OGC_INTERSECTS");
                break;
            }
            case 6: {
                ogcFunction.append("OGC_CONTAINS");
                break;
            }
            case 3: {
                ogcFunction.append("OGC_CROSS");
                break;
            }
            case 1: {
                ogcFunction.append("OGC_DISJOINT");
                break;
            }
            case 0: {
                ogcFunction.append("OGC_EQUALS");
                break;
            }
            case 5: {
                ogcFunction.append("OGC_OVERLAP");
                break;
            }
            case 2: {
                ogcFunction.append("OGC_TOUCH");
                break;
            }
            case 4: {
                ogcFunction.append("OGC_WITHIN");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SpatialRelation (" + spatialRelation + ").");
            }
        }
        ogcFunction.append("(").append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(arg1).append("),").append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(arg2).append(")").append(")");
        return ogcFunction.toString();
    }

    public String getNativeSpatialAggregateSQL(String arg1, int aggregation) {
        StringBuffer aggregateFunction = new StringBuffer();
        SpatialAggregate sa = new SpatialAggregate(aggregation);
        if (sa._aggregateSyntax == null) {
            throw new IllegalArgumentException("Unknown Spatial Aggregation (" + aggregation + ").");
        }
        aggregateFunction.append(sa._aggregateSyntax);
        aggregateFunction.append("(");
        if (sa.isAggregateType()) {
            aggregateFunction.append("SDOAGGRTYPE(");
        }
        aggregateFunction.append(arg1);
        if (sa.isAggregateType()) {
            aggregateFunction.append(", ").append(0.001).append(")");
        }
        aggregateFunction.append(")");
        return aggregateFunction.toString();
    }

    private StringBuffer wrapInSTGeometry(String geomColumn, StringBuffer toAdd) {
        return toAdd.append("MDSYS.ST_GEOMETRY(").append(geomColumn).append(")");
    }

    public String getSpatialFilterExpression(String columnName) {
        StringBuffer buffer = new StringBuffer("SDO_FILTER(");
        buffer.append(columnName);
        buffer.append(",?) = 'TRUE' ");
        return buffer.toString();
    }

    public String getSpatialRelateSQL(String columnName, int spatialRelation, boolean useFilter) {
        String sql = this.isOGCStrict() ? this.getOGCSpatialRelateSQL(columnName, "?", spatialRelation) : this.getNativeSpatialRelateSQL(columnName, "?", spatialRelation);
        sql = sql + " = 1 and " + columnName + " is not null";
        return sql;
    }

    public String getSpatialAnalysisSQL(List args, int spatialAnalysisFunction, boolean useFilter) {
        return this.isOGCStrict() ? this.getOGCSpatialAnalysisSQL(args, spatialAnalysisFunction) : this.getNativeSpatialAnalysisSQL(args, spatialAnalysisFunction);
    }

    public String getSpatialAggregateSQL(String columnName, int spatialAggregateFunction) {
        return this.getNativeSpatialAggregateSQL(columnName, spatialAggregateFunction);
    }

    private String getOGCSpatialAnalysisSQL(List args, int spatialAnalysisFunction) {
        boolean[] geomArgs;
        StringBuffer ogcFunction = new StringBuffer("MDSYS.");
        boolean isGeomReturn = true;
        switch (spatialAnalysisFunction) {
            case 2: {
                ogcFunction.append("OGC_BUFFER");
                geomArgs = new boolean[]{true, false};
                break;
            }
            case 3: {
                ogcFunction.append("OGC_CONVEXHULL");
                geomArgs = new boolean[]{true};
                break;
            }
            case 6: {
                ogcFunction.append("OGC_DIFFERENCE");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 1: {
                ogcFunction.append("OGC_DISTANCE");
                geomArgs = new boolean[]{true, true};
                isGeomReturn = false;
                break;
            }
            case 4: {
                ogcFunction.append("OGC_INTERSECTION");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 7: {
                ogcFunction.append("OGC_SYMMETRICDIFFERENCE");
                geomArgs = new boolean[]{true, true};
                break;
            }
            case 5: {
                ogcFunction.append("OGC_UNION");
                geomArgs = new boolean[]{true, true};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SpatialAnalysisFunction (" + spatialAnalysisFunction + ").");
            }
        }
        if (args.size() < geomArgs.length) {
            throw new QueryException("Insufficient arguments for spatial analysis function (function type:  " + spatialAnalysisFunction + ").");
        }
        ogcFunction.append("(");
        for (int i = 0; i < geomArgs.length; ++i) {
            if (i > 0) {
                ogcFunction.append(",");
            }
            if (geomArgs[i]) {
                this.wrapInSTGeometry((String)args.get(i), ogcFunction);
                continue;
            }
            ogcFunction.append(args.get(i));
        }
        ogcFunction.append(")");
        if (isGeomReturn) {
            ogcFunction.append(".geom");
        }
        return ogcFunction.toString();
    }

    private String getNativeSpatialAnalysisSQL(List args, int spatialAnalysis) {
        return this.getOGCSpatialAnalysisSQL(args, spatialAnalysis);
    }

    private boolean isOGCStrict() {
        return this.features.get(this.OGC_STRICT);
    }

    public String[] getFeatures() {
        return this.features.keySet().toArray(new String[this.features.size()]);
    }

    public boolean getFeature(String name) {
        return this.features.get(name);
    }

    public void setFeature(String name, boolean value) {
        log.info((Object)("Setting feature: " + name + " to " + value));
        this.features.put(name, value);
    }

    public String getDbGeometryTypeName() {
        return "SDO_GEOMETRY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure() {
        String propfileLoc;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL propfile = loader.getResource(propfileLoc = ((Object)((Object)this)).getClass().getCanonicalName() + ".properties");
        if (propfile != null) {
            InputStream is = null;
            log.info((Object)("properties file found: " + propfile));
            try {
                loader.getResource(((Object)((Object)this)).getClass().getCanonicalName());
                is = propfile.openStream();
                PropertyFileReader reader = new PropertyFileReader(is);
                Properties props = reader.getProperties();
                for (String feature : this.getFeatures()) {
                    String newVal = props.getProperty(feature);
                    if (newVal == null) continue;
                    this.setFeature(feature, Boolean.parseBoolean(newVal));
                }
                String ccn = props.getProperty(CONNECTION_FINDER_PROPERTY);
                if (ccn != null) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(ccn);
                        ConnectionFinder cf = (ConnectionFinder)clazz.newInstance();
                        SDOGeometryType.setConnectionFinder(cf);
                        log.info((Object)("Setting ConnectionFinder to " + ccn));
                    }
                    catch (ClassNotFoundException e) {
                        log.warn((Object)("Tried to set ConnectionFinder to " + ccn + ", but class not found."));
                    }
                    catch (InstantiationException e) {
                        log.warn((Object)("Tried to set ConnectionFinder to " + ccn + ", but couldn't instantiate."));
                    }
                    catch (IllegalAccessException e) {
                        log.warn((Object)("Tried to set ConnectionFinder to " + ccn + ", but got IllegalAcessException on instantiation."));
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)("Problem reading properties file " + e));
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean isTwoPhaseFiltering() {
        return false;
    }

    private class SpatialAggregate {
        boolean _aggregateType;
        String _aggregateSyntax;
        private final String SDO_AGGR = "SDO_AGGR_";

        private SpatialAggregate() {
        }

        private SpatialAggregate(int aggregation) {
            String specificAggrSyntax;
            switch (aggregation) {
                case 1: {
                    specificAggrSyntax = "MBR";
                    this._aggregateType = false;
                    break;
                }
                case 100: {
                    specificAggrSyntax = "LRS_CONCAT";
                    this._aggregateType = true;
                    break;
                }
                case 101: {
                    specificAggrSyntax = "CENTROID";
                    this._aggregateType = true;
                    break;
                }
                case 102: {
                    specificAggrSyntax = "CONCAT_LINES";
                    this._aggregateType = false;
                    break;
                }
                case 103: {
                    specificAggrSyntax = "UNION";
                    this._aggregateType = true;
                    break;
                }
                case 104: {
                    specificAggrSyntax = "CONVEXHULL";
                    this._aggregateType = true;
                    break;
                }
                default: {
                    specificAggrSyntax = null;
                }
            }
            if (specificAggrSyntax != null) {
                this._aggregateSyntax = "SDO_AGGR_" + specificAggrSyntax;
            }
        }

        public boolean isAggregateType() {
            return this._aggregateType;
        }

        public String getAggregateSyntax() {
            return this._aggregateSyntax;
        }
    }

    private class SpatialAggregationFunction
    extends StandardSQLFunction {
        private final int aggregation;

        private SpatialAggregationFunction(String name, Type returnType, boolean isProjection, int aggregation) {
            super(name, returnType);
            this.aggregation = aggregation;
        }

        public String render(List args, SessionFactoryImplementor factory) {
            return OracleSpatial10gDialect.this.getNativeSpatialAggregateSQL((String)args.get(0), this.aggregation);
        }
    }

    private class SpatialAnalysisFunction
    extends StandardSQLFunction {
        private final int analysis;

        private SpatialAnalysisFunction(String name, Type returnType, int analysis) {
            super(name, returnType);
            this.analysis = analysis;
        }

        public String render(List args, SessionFactoryImplementor factory) {
            return OracleSpatial10gDialect.this.isOGCStrict() ? OracleSpatial10gDialect.this.getSpatialAnalysisSQL(args, this.analysis, false) : OracleSpatial10gDialect.this.getNativeSpatialAnalysisSQL(args, this.analysis);
        }
    }

    private class SpatialRelateFunction
    extends StandardSQLFunction {
        private final int relation;

        private SpatialRelateFunction(String name, int relation) {
            super(name, (Type)Hibernate.BOOLEAN);
            this.relation = relation;
        }

        public String render(List args, SessionFactoryImplementor factory) {
            if (args.size() < 2) {
                throw new QueryException("Spatial relate functions require at least two arguments");
            }
            return OracleSpatial10gDialect.this.isOGCStrict() ? OracleSpatial10gDialect.this.getOGCSpatialRelateSQL((String)args.get(0), (String)args.get(1), this.relation) : OracleSpatial10gDialect.this.getNativeSpatialRelateSQL((String)args.get(0), (String)args.get(1), this.relation);
        }
    }

    private class GetGeometryTypeFunction
    extends SDOObjectMethod {
        private GetGeometryTypeFunction() {
            super("Get_GType", (Type)Hibernate.STRING);
        }

        public String render(List args, SessionFactoryImplementor factory) {
            StringBuffer buf = new StringBuffer();
            if (args.isEmpty()) {
                throw new IllegalArgumentException("First Argument in arglist must be object to which method is applied");
            }
            buf.append("CASE ").append(args.get(0)).append(".").append(this.getName()).append("()");
            buf.append(" WHEN 1 THEN 'POINT'").append(" WHEN 2 THEN 'LINESTRING'").append(" WHEN 3 THEN 'POLYGON'").append(" WHEN 5 THEN 'MULTIPOINT'").append(" WHEN 6 THEN 'MULTILINE'").append(" WHEN 7 THEN 'MULTIPOLGYON'").append(" END");
            return buf.toString();
        }
    }

    private class WrappedOGCFunction
    extends StandardSQLFunction {
        private final boolean[] geomArrays;

        private WrappedOGCFunction(String name, Type type, boolean[] geomArrays) {
            super(name, type);
            this.geomArrays = geomArrays;
        }

        public String render(List args, SessionFactoryImplementor factory) {
            StringBuffer buf = new StringBuffer();
            buf.append("MDSYS.").append(this.getName()).append("(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                if (this.geomArrays[i]) {
                    buf.append("MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(").append(args.get(i)).append(")");
                    continue;
                }
                buf.append(args.get(i));
            }
            buf.append(")");
            return this.getType().getReturnedClass() == Geometry.class ? buf.append(".geom").toString() : buf.toString();
        }
    }

    private class DimensionFunction
    extends SDOObjectMethod {
        private DimensionFunction() {
            super("Get_GType", (Type)Hibernate.INTEGER);
        }

        public String render(List args, SessionFactoryImplementor factory) {
            StringBuffer buf = new StringBuffer();
            if (args.isEmpty()) {
                throw new IllegalArgumentException("First Argument in arglist must be object to which method is applied");
            }
            buf.append("CASE ").append(args.get(0)).append(".").append(this.getName()).append("()");
            buf.append(" WHEN 1 THEN 0").append(" WHEN 2 THEN 1").append(" WHEN 3 THEN 2").append(" WHEN 5 THEN 0").append(" WHEN 6 THEN 1").append(" WHEN 7 THEN 2").append(" END");
            return buf.toString();
        }
    }

    private class AsTextFunction
    extends StandardSQLFunction {
        private AsTextFunction() {
            super("astext", (Type)Hibernate.STRING);
        }

        public String render(List args, SessionFactoryImplementor factory) {
            StringBuffer buf = new StringBuffer();
            if (args.isEmpty()) {
                throw new IllegalArgumentException("First Argument in arglist must be object to which method is applied");
            }
            buf.append("TO_CHAR(SDO_UTIL.TO_WKTGEOMETRY(").append(args.get(0)).append("))");
            return buf.toString();
        }
    }
}

