/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.hibernate.HibernateException;
import org.hibernatespatial.AbstractDBGeometryType;
import org.hibernatespatial.Circle;
import org.hibernatespatial.HibernateSpatialException;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MLineString;
import org.hibernatespatial.oracle.ConnectionFinder;
import org.hibernatespatial.oracle.DefaultConnectionFinder;

public class SDOGeometryType
extends AbstractDBGeometryType {
    private static final int[] geometryTypes = new int[]{2002};
    private static String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private static ConnectionFinder connectionFinder = new DefaultConnectionFinder();

    static ConnectionFinder getConnectionFinder() {
        return connectionFinder;
    }

    static void setConnectionFinder(ConnectionFinder finder) {
        connectionFinder = finder;
    }

    static void setSQLTypeName(String typeName) {
        SQL_TYPE_NAME = typeName;
    }

    static String getSQLTypeName() {
        return SQL_TYPE_NAME;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0], SQL_TYPE_NAME);
        } else {
            Geometry jtsGeom = (Geometry)value;
            try {
                Object dbGeom = this.conv2DBGeometry(jtsGeom, (Connection)SDOGeometryType.getConnectionFinder().find(st.getConnection()));
                st.setObject(index, dbGeom);
            }
            catch (FinderException e) {
                throw new HibernateException((Throwable)e);
            }
        }
    }

    public Object conv2DBGeometry(Geometry jtsGeom, Connection connection) {
        SDO_GEOMETRY geom = this.convertJTSGeometry(jtsGeom);
        if (geom != null) {
            try {
                return SDO_GEOMETRY.store(geom, (Connection)((OracleConnection)connection));
            }
            catch (SQLException e) {
                throw new HibernateSpatialException("Problem during conversion from JTS to JGeometry", (Throwable)e);
            }
        }
        throw new UnsupportedOperationException("Conversion of " + jtsGeom.getClass().getSimpleName() + " to Oracle STRUCT not supported");
    }

    private SDO_GEOMETRY convertJTSGeometry(Geometry jtsGeom) {
        SDO_GEOMETRY geom = null;
        if (jtsGeom instanceof Point) {
            geom = this.convertJTSPoint((Point)jtsGeom);
        } else if (jtsGeom instanceof LineString) {
            geom = this.convertJTSLineString((LineString)jtsGeom);
        } else if (jtsGeom instanceof Polygon) {
            geom = this.convertJTSPolygon((Polygon)jtsGeom);
        } else if (jtsGeom instanceof MultiPoint) {
            geom = this.convertJTSMultiPoint((MultiPoint)jtsGeom);
        } else if (jtsGeom instanceof MultiLineString) {
            geom = this.convertJTSMultiLineString((MultiLineString)jtsGeom);
        } else if (jtsGeom instanceof MultiPolygon) {
            geom = this.convertJTSMultiPolygon((MultiPolygon)jtsGeom);
        } else if (jtsGeom instanceof GeometryCollection) {
            geom = this.convertJTSGeometryCollection((GeometryCollection)jtsGeom);
        }
        return geom;
    }

    private SDO_GEOMETRY convertJTSGeometryCollection(GeometryCollection collection) {
        SDO_GEOMETRY[] sdoElements = new SDO_GEOMETRY[collection.getNumGeometries()];
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            Geometry geom = collection.getGeometryN(i);
            sdoElements[i] = this.convertJTSGeometry(geom);
        }
        return SDO_GEOMETRY.join(sdoElements);
    }

    private SDO_GEOMETRY convertJTSMultiPolygon(MultiPolygon multiPolygon) {
        int dim = this.getCoordDimension((Geometry)multiPolygon);
        int lrsPos = this.getCoordinateLrsPosition((Geometry)multiPolygon);
        SDO_GEOMETRY geom = new SDO_GEOMETRY();
        geom.setGType(new SDO_GTYPE(dim, lrsPos, TypeGeometry.MULTIPOLYGON));
        geom.setSRID(multiPolygon.getSRID());
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            try {
                Polygon pg = (Polygon)multiPolygon.getGeometryN(i);
                this.addPolygon(geom, pg);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Found geometry that was not a geometry in MultiPolygon");
            }
        }
        return geom;
    }

    private SDO_GEOMETRY convertJTSLineString(LineString lineString) {
        int dim = this.getCoordDimension((Geometry)lineString);
        int lrsPos = this.getCoordinateLrsPosition((Geometry)lineString);
        boolean isLrs = lrsPos > 0;
        Double[] ordinates = this.convertCoordinates(lineString.getCoordinates(), dim, isLrs);
        SDO_GEOMETRY geom = new SDO_GEOMETRY();
        geom.setGType(new SDO_GTYPE(dim, lrsPos, TypeGeometry.LINE));
        geom.setSRID(lineString.getSRID());
        ELEM_INFO info = new ELEM_INFO(1);
        info.setElement(0, 1, ElementType.LINE_STRAITH_SEGMENTS, 0);
        geom.setInfo(info);
        geom.setOrdinates(new ORDINATES(ordinates));
        return geom;
    }

    private SDO_GEOMETRY convertJTSMultiPoint(MultiPoint multiPoint) {
        int dim = this.getCoordDimension((Geometry)multiPoint);
        int lrsDim = this.getCoordinateLrsPosition((Geometry)multiPoint);
        boolean isLrs = lrsDim != 0;
        SDO_GEOMETRY geom = new SDO_GEOMETRY();
        geom.setGType(new SDO_GTYPE(dim, lrsDim, TypeGeometry.MULTIPOINT));
        geom.setSRID(multiPoint.getSRID());
        ELEM_INFO info = new ELEM_INFO(multiPoint.getNumPoints());
        int oordinatesOffset = 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiPoint.getNumPoints(); ++i) {
            info.setElement(i, oordinatesOffset, ElementType.POINT, 0);
            ordinates = this.convertAddCoordinates(ordinates, multiPoint.getGeometryN(i).getCoordinates(), dim, isLrs);
            oordinatesOffset = ordinates.length + 1;
        }
        geom.setInfo(info);
        geom.setOrdinates(new ORDINATES(ordinates));
        return geom;
    }

    private SDO_GEOMETRY convertJTSPoint(Point jtsGeom) {
        int dim = this.getCoordDimension((Geometry)jtsGeom);
        int lrsDim = this.getCoordinateLrsPosition((Geometry)jtsGeom);
        boolean isLrs = lrsDim != 0;
        Double[] coord = this.convertCoordinates(jtsGeom.getCoordinates(), dim, isLrs);
        SDO_GEOMETRY geom = new SDO_GEOMETRY();
        geom.setGType(new SDO_GTYPE(dim, lrsDim, TypeGeometry.POINT));
        geom.setSRID(jtsGeom.getSRID());
        ELEM_INFO info = new ELEM_INFO(1);
        info.setElement(0, 1, ElementType.POINT, 1);
        geom.setInfo(info);
        geom.setOrdinates(new ORDINATES(coord));
        return geom;
    }

    private SDO_GEOMETRY convertJTSPolygon(Polygon polygon) {
        int dim = this.getCoordDimension((Geometry)polygon);
        int lrsPos = this.getCoordinateLrsPosition((Geometry)polygon);
        SDO_GEOMETRY geom = new SDO_GEOMETRY();
        geom.setGType(new SDO_GTYPE(dim, lrsPos, TypeGeometry.POLYGON));
        geom.setSRID(polygon.getSRID());
        this.addPolygon(geom, polygon);
        return geom;
    }

    private void addPolygon(SDO_GEOMETRY geom, Polygon polygon) {
        int numInteriorRings = polygon.getNumInteriorRing();
        ELEM_INFO info = new ELEM_INFO(numInteriorRings + 1);
        int ordinatesOffset = 1;
        if (geom.getOrdinates() != null) {
            ordinatesOffset = geom.getOrdinates().getOrdinateArray().length + 1;
        }
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < info.getSize(); ++i) {
            Coordinate[] coords;
            ElementType et;
            if (i == 0) {
                et = ElementType.EXTERIOR_RING_STRAIGHT_SEGMENTS;
                coords = polygon.getExteriorRing().getCoordinates();
                if (!CGAlgorithms.isCCW((Coordinate[])coords)) {
                    coords = this.reverseRing(coords);
                }
            } else {
                et = ElementType.INTERIOR_RING_STRAIGHT_SEGMENTS;
                coords = polygon.getInteriorRingN(i - 1).getCoordinates();
                if (CGAlgorithms.isCCW((Coordinate[])coords)) {
                    coords = this.reverseRing(coords);
                }
            }
            info.setElement(i, ordinatesOffset, et, 0);
            ordinates = this.convertAddCoordinates(ordinates, coords, geom.getDimension(), geom.isLRSGeometry());
            ordinatesOffset = ordinates.length + 1;
        }
        geom.addElement(info);
        geom.addOrdinates(ordinates);
    }

    private SDO_GEOMETRY convertJTSMultiLineString(MultiLineString multiLineString) {
        int dim = this.getCoordDimension((Geometry)multiLineString);
        int lrsDim = this.getCoordinateLrsPosition((Geometry)multiLineString);
        boolean isLrs = lrsDim != 0;
        SDO_GEOMETRY geom = new SDO_GEOMETRY();
        geom.setGType(new SDO_GTYPE(dim, lrsDim, TypeGeometry.MULTILINE));
        geom.setSRID(multiLineString.getSRID());
        ELEM_INFO info = new ELEM_INFO(multiLineString.getNumGeometries());
        int oordinatesOffset = 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            info.setElement(i, oordinatesOffset, ElementType.LINE_STRAITH_SEGMENTS, 0);
            ordinates = this.convertAddCoordinates(ordinates, multiLineString.getGeometryN(i).getCoordinates(), dim, isLrs);
            oordinatesOffset = ordinates.length + 1;
        }
        geom.setInfo(info);
        geom.setOrdinates(new ORDINATES(ordinates));
        return geom;
    }

    private Double[] convertAddCoordinates(Double[] ordinates, Coordinate[] coordinates, int dim, boolean isLrs) {
        Double[] no = this.convertCoordinates(coordinates, dim, isLrs);
        Double[] newordinates = new Double[ordinates.length + no.length];
        System.arraycopy(ordinates, 0, newordinates, 0, ordinates.length);
        System.arraycopy(no, 0, newordinates, ordinates.length, no.length);
        return newordinates;
    }

    private Double[] convertCoordinates(Coordinate[] coordinates, int dim, boolean isLrs) {
        if (dim > 4) {
            throw new IllegalArgumentException("Dim parameter value cannot be greater than 4");
        }
        Double[] converted = new Double[coordinates.length * dim];
        for (int i = 0; i < coordinates.length; ++i) {
            MCoordinate c = MCoordinate.convertCoordinate((Coordinate)coordinates[i]);
            converted[i * dim] = this.toDouble(c.x);
            converted[i * dim + 1] = this.toDouble(c.y);
            if (dim == 3) {
                converted[i * dim + 2] = isLrs ? this.toDouble(c.m) : this.toDouble(c.z);
                continue;
            }
            if (dim != 4) continue;
            converted[i * dim + 2] = this.toDouble(c.z);
            converted[i * dim + 3] = this.toDouble(c.m);
        }
        return converted;
    }

    private Double toDouble(double d) {
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    private int getCoordDimension(Geometry geom) {
        MCoordinate c = MCoordinate.convertCoordinate((Coordinate)geom.getCoordinate());
        int d = 0;
        if (c != null) {
            if (!Double.isNaN(c.x)) {
                ++d;
            }
            if (!Double.isNaN(c.y)) {
                ++d;
            }
            if (!Double.isNaN(c.z)) {
                ++d;
            }
            if (!Double.isNaN(c.m)) {
                ++d;
            }
        }
        return d;
    }

    private int getCoordinateLrsPosition(Geometry geom) {
        MCoordinate c = MCoordinate.convertCoordinate((Coordinate)geom.getCoordinate());
        int measurePos = 0;
        if (c != null && !Double.isNaN(c.m)) {
            measurePos = Double.isNaN(c.z) ? 3 : 4;
        }
        return measurePos;
    }

    public Geometry convert2JTS(Object struct) {
        if (struct == null) {
            return null;
        }
        SDO_GEOMETRY sdoGeom = SDO_GEOMETRY.load((STRUCT)struct);
        return this.convert2JTS(sdoGeom);
    }

    public Geometry convert2JTS(SDO_GEOMETRY sdoGeom) {
        int dim = sdoGeom.getGType().getDimension();
        int lrsDim = sdoGeom.getGType().getLRSDimension();
        switch (sdoGeom.getGType().getTypeGeometry()) {
            case POINT: {
                return this.convertSDOPoint(sdoGeom);
            }
            case LINE: {
                return this.convertSDOLine(dim, lrsDim, sdoGeom);
            }
            case POLYGON: {
                return this.convertSDOPolygon(dim, lrsDim, sdoGeom);
            }
            case MULTIPOINT: {
                return this.convertSDOMultiPoint(dim, lrsDim, sdoGeom);
            }
            case MULTILINE: {
                return this.convertSDOMultiLine(dim, lrsDim, sdoGeom);
            }
            case MULTIPOLYGON: {
                return this.convertSDOMultiPolygon(dim, lrsDim, sdoGeom);
            }
            case COLLECTION: {
                return this.convertSDOCollection(dim, lrsDim, sdoGeom);
            }
        }
        throw new IllegalArgumentException("Type not supported: " + (Object)((Object)sdoGeom.getGType().getTypeGeometry()));
    }

    private Geometry convertSDOCollection(int dim, int lrsDim, SDO_GEOMETRY sdoGeom) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (SDO_GEOMETRY elemGeom : sdoGeom.getElementGeometries()) {
            geometries.add(this.convert2JTS(elemGeom));
        }
        Geometry[] geomArray = new Geometry[geometries.size()];
        return this.getGeometryFactory().createGeometryCollection(geometries.toArray(geomArray));
    }

    private Point convertSDOPoint(SDO_GEOMETRY sdoGeom) {
        Double[] ordinates = sdoGeom.getOrdinates().getOrdinateArray();
        if (ordinates.length == 0) {
            ordinates = sdoGeom.getDimension() == 2 ? new Double[]{sdoGeom.getPoint().x, sdoGeom.getPoint().y} : new Double[]{sdoGeom.getPoint().x, sdoGeom.getPoint().y, sdoGeom.getPoint().z};
        }
        CoordinateSequence cs = this.convertOrdinateArray(ordinates, sdoGeom);
        Point point = this.getGeometryFactory().createPoint(cs);
        point.setSRID(sdoGeom.getSRID());
        return point;
    }

    private MultiPoint convertSDOMultiPoint(int dim, int lrsDim, SDO_GEOMETRY sdoGeom) {
        Double[] ordinates = sdoGeom.getOrdinates().getOrdinateArray();
        CoordinateSequence cs = this.convertOrdinateArray(ordinates, sdoGeom);
        MultiPoint multipoint = this.getGeometryFactory().createMultiPoint(cs);
        multipoint.setSRID(sdoGeom.getSRID());
        return multipoint;
    }

    private LineString convertSDOLine(int dim, int lrsDim, SDO_GEOMETRY sdoGeom) {
        boolean lrs = sdoGeom.isLRSGeometry();
        ELEM_INFO info = sdoGeom.getInfo();
        CoordinateSequence cs = null;
        int i = 0;
        while (i < info.getSize()) {
            if (info.getElementType(i).isCompound()) {
                int numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
                i += 1 + numCompounds;
                continue;
            }
            cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false));
            ++i;
        }
        MLineString ls = lrs ? this.getGeometryFactory().createMLineString(cs) : this.getGeometryFactory().createLineString(cs);
        ls.setSRID(sdoGeom.getSRID());
        return ls;
    }

    private MultiLineString convertSDOMultiLine(int dim, int lrsDim, SDO_GEOMETRY sdoGeom) {
        boolean lrs = sdoGeom.isLRSGeometry();
        ELEM_INFO info = sdoGeom.getInfo();
        MLineString[] lines = lrs ? new MLineString[sdoGeom.getInfo().getSize()] : new LineString[sdoGeom.getInfo().getSize()];
        int i = 0;
        while (i < info.getSize()) {
            MLineString line;
            CoordinateSequence cs = null;
            if (info.getElementType(i).isCompound()) {
                MLineString line2;
                int numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
                lines[i] = line2 = lrs ? this.getGeometryFactory().createMLineString(cs) : this.getGeometryFactory().createLineString(cs);
                i += 1 + numCompounds;
                continue;
            }
            cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false));
            lines[i] = line = lrs ? this.getGeometryFactory().createMLineString(cs) : this.getGeometryFactory().createLineString(cs);
            ++i;
        }
        MultiLineString mls = lrs ? this.getGeometryFactory().createMultiMLineString(lines) : this.getGeometryFactory().createMultiLineString((LineString[])lines);
        mls.setSRID(sdoGeom.getSRID());
        return mls;
    }

    private Geometry convertSDOPolygon(int dim, int lrsDim, SDO_GEOMETRY sdoGeom) {
        int numCompounds;
        LinearRing shell = null;
        LinearRing[] holes = new LinearRing[sdoGeom.getNumElements() - 1];
        ELEM_INFO info = sdoGeom.getInfo();
        int idxInteriorRings = 0;
        for (int i = 0; i < info.getSize(); i += 1 + numCompounds) {
            CoordinateSequence cs = null;
            numCompounds = 0;
            if (info.getElementType(i).isCompound()) {
                numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
            } else {
                cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false));
            }
            if (info.getElementType(i).isInteriorRing()) {
                holes[idxInteriorRings] = this.getGeometryFactory().createLinearRing(cs);
                holes[idxInteriorRings].setSRID(sdoGeom.getSRID());
                ++idxInteriorRings;
                continue;
            }
            shell = this.getGeometryFactory().createLinearRing(cs);
            shell.setSRID(sdoGeom.getSRID());
        }
        Polygon polygon = this.getGeometryFactory().createPolygon(shell, holes);
        polygon.setSRID(sdoGeom.getSRID());
        return polygon;
    }

    private MultiPolygon convertSDOMultiPolygon(int dim, int lrsDim, SDO_GEOMETRY sdoGeom) {
        int numCompounds;
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        ELEM_INFO info = sdoGeom.getInfo();
        LinearRing shell = null;
        for (int i = 0; i < info.getSize(); i += 1 + numCompounds) {
            CoordinateSequence cs = null;
            numCompounds = 0;
            if (info.getElementType(i).isCompound()) {
                numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
            } else {
                cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false));
            }
            if (info.getElementType(i).isInteriorRing()) {
                LinearRing lr = this.getGeometryFactory().createLinearRing(cs);
                lr.setSRID(sdoGeom.getSRID());
                holes.add(lr);
                continue;
            }
            if (shell != null) {
                Polygon polygon = this.getGeometryFactory().createPolygon(shell, holes.toArray(new LinearRing[holes.size()]));
                polygon.setSRID(sdoGeom.getSRID());
                polygons.add(polygon);
                shell = null;
            }
            shell = this.getGeometryFactory().createLinearRing(cs);
            shell.setSRID(sdoGeom.getSRID());
            holes = new ArrayList();
        }
        if (shell != null) {
            Polygon polygon = this.getGeometryFactory().createPolygon(shell, holes.toArray(new LinearRing[holes.size()]));
            polygon.setSRID(sdoGeom.getSRID());
            polygons.add(polygon);
        }
        MultiPolygon multiPolygon = this.getGeometryFactory().createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        multiPolygon.setSRID(sdoGeom.getSRID());
        return multiPolygon;
    }

    private CoordinateSequence getCompoundCSeq(int idxFirst, int idxLast, SDO_GEOMETRY sdoGeom) {
        CoordinateSequence cs = null;
        for (int i = idxFirst; i <= idxLast; ++i) {
            if (cs != null && cs.size() > 0) {
                Coordinate[] coordinates = cs.toCoordinateArray();
                Coordinate[] newCoordinates = new Coordinate[coordinates.length - 1];
                System.arraycopy(coordinates, 0, newCoordinates, 0, coordinates.length - 1);
                cs = this.getGeometryFactory().getCoordinateSequenceFactory().create(newCoordinates);
            }
            cs = this.add(cs, this.getElementCSeq(i, sdoGeom, i < idxLast));
        }
        return cs;
    }

    private CoordinateSequence getElementCSeq(int i, SDO_GEOMETRY sdoGeom, boolean hasNextSE) {
        ElementType type = sdoGeom.getInfo().getElementType(i);
        Double[] elemOrdinates = this.extractOrdinatesOfElement(i, sdoGeom, hasNextSE);
        CoordinateSequence cs = null;
        if (type.isStraightSegment()) {
            cs = this.convertOrdinateArray(elemOrdinates, sdoGeom);
        } else if (type.isArcSegment() || type.isCircle()) {
            Coordinate[] linearized = this.linearize(elemOrdinates, sdoGeom.getDimension(), sdoGeom.isLRSGeometry(), type.isCircle());
            cs = this.getGeometryFactory().getCoordinateSequenceFactory().create(linearized);
        } else if (type.isRect()) {
            cs = this.convertOrdinateArray(elemOrdinates, sdoGeom);
            Coordinate ll = cs.getCoordinate(0);
            Coordinate ur = cs.getCoordinate(1);
            Coordinate lr = new Coordinate(ur.x, ll.y);
            Coordinate ul = new Coordinate(ll.x, ur.y);
            cs = type.isExteriorRing() ? this.getGeometryFactory().getCoordinateSequenceFactory().create(new Coordinate[]{ll, lr, ur, ul, ll}) : this.getGeometryFactory().getCoordinateSequenceFactory().create(new Coordinate[]{ll, ul, ur, lr, ll});
        } else {
            throw new RuntimeException("Unexpected Element type in compound: " + (Object)((Object)type));
        }
        return cs;
    }

    private CoordinateSequence add(CoordinateSequence seq1, CoordinateSequence seq2) {
        if (seq1 == null) {
            return seq2;
        }
        if (seq2 == null) {
            return seq1;
        }
        Coordinate[] c1 = seq1.toCoordinateArray();
        Coordinate[] c2 = seq2.toCoordinateArray();
        Coordinate[] c3 = new Coordinate[c1.length + c2.length];
        System.arraycopy(c1, 0, c3, 0, c1.length);
        System.arraycopy(c2, 0, c3, c1.length, c2.length);
        return this.getGeometryFactory().getCoordinateSequenceFactory().create(c3);
    }

    private Double[] extractOrdinatesOfElement(int element, SDO_GEOMETRY sdoGeom, boolean hasNextSE) {
        int start = sdoGeom.getInfo().getOrdinatesOffset(element);
        if (element < sdoGeom.getInfo().getSize() - 1) {
            int end = sdoGeom.getInfo().getOrdinatesOffset(element + 1);
            if (hasNextSE) {
                end += sdoGeom.getDimension();
            }
            return sdoGeom.getOrdinates().getOrdinatesArray(start, end);
        }
        return sdoGeom.getOrdinates().getOrdinatesArray(start);
    }

    private CoordinateSequence convertOrdinateArray(Double[] oordinates, SDO_GEOMETRY sdoGeom) {
        int dim = sdoGeom.getDimension();
        Coordinate[] coordinates = new Coordinate[oordinates.length / dim];
        int zDim = sdoGeom.getZDimension() - 1;
        int lrsDim = sdoGeom.getLRSDimension() - 1;
        for (int i = 0; i < coordinates.length; ++i) {
            if (dim == 2) {
                coordinates[i] = new Coordinate(oordinates[i * dim].doubleValue(), oordinates[i * dim + 1].doubleValue());
                continue;
            }
            if (dim == 3) {
                if (sdoGeom.isLRSGeometry()) {
                    coordinates[i] = MCoordinate.create2dWithMeasure((double)oordinates[i * dim], (double)oordinates[i * dim + 1], (double)oordinates[i * dim + lrsDim]);
                    continue;
                }
                coordinates[i] = new Coordinate(oordinates[i * dim].doubleValue(), oordinates[i * dim + 1].doubleValue(), oordinates[i * dim + zDim].doubleValue());
                continue;
            }
            if (dim != 4) continue;
            if (!sdoGeom.isLRSGeometry()) {
                throw new HibernateSpatialException("4 dimensional Geometries must be LRS geometry");
            }
            coordinates[i] = MCoordinate.create3dWithMeasure((double)oordinates[i * dim], (double)oordinates[i * dim + 1], (double)oordinates[i * dim + zDim], (double)oordinates[i * dim + lrsDim]);
        }
        return this.getGeometryFactory().getCoordinateSequenceFactory().create(coordinates);
    }

    private Coordinate[] reverseRing(Coordinate[] ar) {
        for (int i = 0; i < ar.length / 2; ++i) {
            Coordinate cs = ar[i];
            ar[i] = ar[ar.length - 1 - i];
            ar[ar.length - 1 - i] = cs;
        }
        return ar;
    }

    private Coordinate[] linearize(Double[] arcOrdinates, int dim, boolean lrs, boolean entireCirlce) {
        int coordDim;
        Coordinate[] linearizedCoords = new Coordinate[]{};
        int n = coordDim = lrs ? dim - 1 : dim;
        if (coordDim != 2) {
            throw new IllegalArgumentException("Can only linearize 2D arc segments, but geometry is " + dim + "D.");
        }
        int numOrd = dim;
        while (numOrd < arcOrdinates.length) {
            numOrd -= dim;
            double x1 = arcOrdinates[numOrd++];
            double y1 = arcOrdinates[numOrd++];
            double m1 = lrs ? arcOrdinates[numOrd++] : Double.NaN;
            double x2 = arcOrdinates[numOrd++];
            double y2 = arcOrdinates[numOrd++];
            double m2 = lrs ? arcOrdinates[numOrd++] : Double.NaN;
            double x3 = arcOrdinates[numOrd++];
            double y3 = arcOrdinates[numOrd++];
            double m3 = lrs ? arcOrdinates[numOrd++] : Double.NaN;
            Coordinate[] coords = entireCirlce ? Circle.linearizeCircle((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3) : Circle.linearizeArc((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3);
            if (lrs) {
                MCoordinate[] mcoord = new MCoordinate[coords.length];
                int lastIndex = coords.length - 1;
                mcoord[0] = MCoordinate.create2dWithMeasure((double)x1, (double)y1, (double)m1);
                mcoord[lastIndex] = MCoordinate.create2dWithMeasure((double)x3, (double)y3, (double)m3);
                for (int i = 1; i < lastIndex; ++i) {
                    mcoord[i] = MCoordinate.convertCoordinate((Coordinate)coords[i]);
                    if (Double.compare(mcoord[i].x, x2) != 0 || Double.compare(mcoord[i].y, y2) != 0) continue;
                    mcoord[i].m = m2;
                }
                coords = mcoord;
            }
            int resultBegin = 1;
            if (linearizedCoords.length == 0) {
                resultBegin = 0;
            }
            int destPos = linearizedCoords.length;
            Coordinate[] tmpCoords = new Coordinate[linearizedCoords.length + coords.length - resultBegin];
            System.arraycopy(linearizedCoords, 0, tmpCoords, 0, linearizedCoords.length);
            System.arraycopy(coords, resultBegin, tmpCoords, destPos, coords.length - resultBegin);
            linearizedCoords = tmpCoords;
        }
        return linearizedCoords;
    }

    public int[] sqlTypes() {
        return geometryTypes;
    }

    public static String arrayToString(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return "()";
        }
        int length = Array.getLength(array);
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            stb.append(",").append(Array.get(array, i));
        }
        stb.append(")");
        return stb.toString();
    }

    private static SDO_GTYPE deriveGTYPE(ElementType elementType, SDO_GEOMETRY origGeom) {
        switch (elementType) {
            case POINT: 
            case ORIENTATION: {
                return new SDO_GTYPE(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.POINT);
            }
            case POINT_CLUSTER: {
                return new SDO_GTYPE(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.MULTIPOINT);
            }
            case LINE_ARC_SEGMENTS: 
            case LINE_STRAITH_SEGMENTS: 
            case COMPOUND_LINE: {
                return new SDO_GTYPE(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.LINE);
            }
            case COMPOUND_EXTERIOR_RING: 
            case EXTERIOR_RING_ARC_SEGMENTS: 
            case EXTERIOR_RING_CIRCLE: 
            case EXTERIOR_RING_RECT: 
            case EXTERIOR_RING_STRAIGHT_SEGMENTS: {
                return new SDO_GTYPE(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.POLYGON);
            }
        }
        return null;
    }

    public static class SDO_GEOMETRY {
        private static final String TYPE_NAME = "MDSYS.SDO_GEOMETRY";
        private static StructDescriptor structDescriptor = null;
        private SDO_GTYPE gtype;
        private int srid;
        private SDO_POINT point;
        private ELEM_INFO info;
        private ORDINATES ordinates;

        public static SDO_GEOMETRY join(SDO_GEOMETRY[] sdoElements) {
            SDO_GEOMETRY sdoCollection = new SDO_GEOMETRY();
            if (sdoElements == null || sdoElements.length == 0) {
                sdoCollection.setGType(new SDO_GTYPE(2, 0, TypeGeometry.COLLECTION));
            } else {
                SDO_GEOMETRY firstElement = sdoElements[0];
                int dim = firstElement.getGType().getDimension();
                int lrsDim = firstElement.getGType().getLRSDimension();
                sdoCollection.setGType(new SDO_GTYPE(dim, lrsDim, TypeGeometry.COLLECTION));
                int ordinatesOffset = 1;
                for (int i = 0; i < sdoElements.length; ++i) {
                    ELEM_INFO element = sdoElements[i].getInfo();
                    Double[] ordinates = sdoElements[i].getOrdinates().getOrdinateArray();
                    if (element == null || element.getSize() <= 0) continue;
                    int shift = ordinatesOffset - element.getOrdinatesOffset(0);
                    SDO_GEOMETRY.shiftOrdinateOffset(element, shift);
                    sdoCollection.addElement(element);
                    sdoCollection.addOrdinates(ordinates);
                    ordinatesOffset += ordinates.length;
                }
            }
            return sdoCollection;
        }

        public ELEM_INFO getInfo() {
            return this.info;
        }

        public void setInfo(ELEM_INFO info) {
            this.info = info;
        }

        public SDO_GTYPE getGType() {
            return this.gtype;
        }

        public void setGType(SDO_GTYPE gtype) {
            this.gtype = gtype;
        }

        public ORDINATES getOrdinates() {
            return this.ordinates;
        }

        public void setOrdinates(ORDINATES ordinates) {
            this.ordinates = ordinates;
        }

        public SDO_POINT getPoint() {
            return this.point;
        }

        public void setPoint(SDO_POINT point) {
            this.point = point;
        }

        public int getSRID() {
            return this.srid;
        }

        public void setSRID(int srid) {
            this.srid = srid;
        }

        public static SDO_GEOMETRY load(STRUCT struct) {
            Datum[] data;
            try {
                data = struct.getOracleAttributes();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            SDO_GEOMETRY geom = new SDO_GEOMETRY();
            geom.setGType(SDO_GTYPE.parse(data[0]));
            geom.setSRID(data[1]);
            if (data[2] != null) {
                geom.setPoint(new SDO_POINT((STRUCT)data[2]));
            }
            geom.setInfo(new ELEM_INFO((ARRAY)data[3]));
            geom.setOrdinates(new ORDINATES((ARRAY)data[4]));
            return geom;
        }

        public static STRUCT store(SDO_GEOMETRY geom, Connection conn) throws SQLException {
            if (structDescriptor == null) {
                structDescriptor = StructDescriptor.createDescriptor((String)TYPE_NAME, (Connection)conn);
            } else {
                structDescriptor.setConnection(conn);
            }
            Object[] attributes = new Datum[5];
            attributes[0] = new NUMBER(geom.getGType().intValue());
            attributes[1] = geom.getSRID() > 0 ? new NUMBER(geom.getSRID()) : null;
            attributes[3] = geom.getInfo().toOracleArray(conn);
            attributes[4] = geom.getOrdinates().toOracleArray(conn);
            return new STRUCT(structDescriptor, conn, attributes);
        }

        private void setSRID(Datum datum) {
            if (datum == null) {
                this.srid = 0;
                return;
            }
            try {
                this.srid = new Integer(((NUMBER)datum).intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isLRSGeometry() {
            return this.gtype.isLRSGeometry();
        }

        public int getDimension() {
            return this.gtype.getDimension();
        }

        public int getLRSDimension() {
            return this.gtype.getLRSDimension();
        }

        public int getZDimension() {
            return this.gtype.getZDimension();
        }

        public int getNumElements() {
            int cnt = 0;
            int i = 0;
            while (i < this.info.getSize()) {
                if (this.info.getElementType(i).isCompound()) {
                    int numCompounds = this.info.getNumCompounds(i);
                    i += 1 + numCompounds;
                } else {
                    ++i;
                }
                ++cnt;
            }
            return cnt;
        }

        public String toString() {
            StringBuilder stb = new StringBuilder();
            stb.append("(").append(this.gtype).append(",").append(this.srid).append(",").append(this.point).append(",").append(this.info).append(",").append(this.ordinates).append(")");
            return stb.toString();
        }

        public void addOrdinates(Double[] newOrdinates) {
            if (this.ordinates == null) {
                this.ordinates = new ORDINATES(newOrdinates);
            } else {
                this.ordinates.addOrdinates(newOrdinates);
            }
        }

        public void addElement(ELEM_INFO element) {
            if (this.info == null) {
                this.info = element;
            } else {
                this.info.addElement(element);
            }
        }

        public SDO_GEOMETRY[] getElementGeometries() {
            if (this.getGType().getTypeGeometry() == TypeGeometry.COLLECTION) {
                ArrayList<SDO_GEOMETRY> elements = new ArrayList<SDO_GEOMETRY>();
                int i = 0;
                while (i < this.getNumElements()) {
                    int next;
                    ElementType et = this.getInfo().getElementType(i);
                    if (et.isExteriorRing()) {
                        for (next = i + 1; next < this.getNumElements() && this.getInfo().getElementType(next).isInteriorRing(); ++next) {
                        }
                    } else if (et.isCompound()) {
                        next = i + this.getInfo().getNumCompounds(i) + 1;
                    }
                    SDO_GEOMETRY elemGeom = new SDO_GEOMETRY();
                    SDO_GTYPE elemGtype = SDOGeometryType.deriveGTYPE(this.getInfo().getElementType(i), this);
                    elemGeom.setGType(elemGtype);
                    elemGeom.setSRID(this.getSRID());
                    ELEM_INFO elemInfo = new ELEM_INFO(this.getInfo().getElement(i));
                    SDO_GEOMETRY.shiftOrdinateOffset(elemInfo, -elemInfo.getOrdinatesOffset(0) + 1);
                    elemGeom.setInfo(elemInfo);
                    int startPosition = this.getInfo().getOrdinatesOffset(i);
                    ORDINATES elemOrdinates = null;
                    if (next < this.getNumElements()) {
                        int endPosition = this.getInfo().getOrdinatesOffset(next);
                        elemOrdinates = new ORDINATES(this.getOrdinates().getOrdinatesArray(startPosition, endPosition));
                    } else {
                        elemOrdinates = new ORDINATES(this.getOrdinates().getOrdinatesArray(startPosition));
                    }
                    elemGeom.setOrdinates(elemOrdinates);
                    elements.add(elemGeom);
                    i = next;
                }
                return elements.toArray(new SDO_GEOMETRY[elements.size()]);
            }
            return new SDO_GEOMETRY[]{this};
        }

        private static void shiftOrdinateOffset(ELEM_INFO elemInfo, int offset) {
            for (int i = 0; i < elemInfo.getSize(); ++i) {
                int newOffset = elemInfo.getOrdinatesOffset(i) + offset;
                elemInfo.setOrdinatesOffset(i, newOffset);
            }
        }
    }

    public static class ORDINATES {
        private static final String TYPE_NAME = "MDSYS.SDO_ORDINATE_ARRAY";
        private static ArrayDescriptor arrayDescriptor = null;
        private Double[] ordinates;

        public ORDINATES(Double[] ordinates) {
            this.ordinates = ordinates;
        }

        public ORDINATES(ARRAY array) {
            if (array == null) {
                this.ordinates = new Double[0];
                return;
            }
            try {
                Number[] ords = (Number[])array.getArray();
                this.ordinates = new Double[ords.length];
                for (int i = 0; i < ords.length; ++i) {
                    this.ordinates[i] = ords[i] != null ? ords[i].doubleValue() : Double.NaN;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Double[] getOrdinateArray() {
            return this.ordinates;
        }

        public Double[] getOrdinatesArray(int startPosition, int endPosition) {
            Double[] a = new Double[endPosition - startPosition];
            System.arraycopy(this.ordinates, startPosition - 1, a, 0, a.length);
            return a;
        }

        public Double[] getOrdinatesArray(int startPosition) {
            Double[] a = new Double[this.ordinates.length - (startPosition - 1)];
            System.arraycopy(this.ordinates, startPosition - 1, a, 0, a.length);
            return a;
        }

        public String toString() {
            return SDOGeometryType.arrayToString(this.ordinates);
        }

        public void addOrdinates(Double[] ordinatesToAdd) {
            Double[] newOrdinates = new Double[this.ordinates.length + ordinatesToAdd.length];
            System.arraycopy(this.ordinates, 0, newOrdinates, 0, this.ordinates.length);
            System.arraycopy(ordinatesToAdd, 0, newOrdinates, this.ordinates.length, ordinatesToAdd.length);
            this.ordinates = newOrdinates;
        }

        public ARRAY toOracleArray(Connection conn) throws SQLException {
            if (arrayDescriptor == null) {
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)TYPE_NAME, (Connection)conn);
            } else {
                arrayDescriptor.setConnection(conn);
            }
            return new ARRAY(arrayDescriptor, conn, (Object)this.ordinates);
        }
    }

    public static class ELEM_INFO {
        private static final String TYPE_NAME = "MDSYS.SDO_ELEM_INFO_ARRAY";
        private static ArrayDescriptor arrayDescriptor = null;
        private int[] triplets;

        public ELEM_INFO(int size) {
            this.triplets = new int[3 * size];
        }

        public ELEM_INFO(int[] elem_info) {
            this.triplets = elem_info;
        }

        public ELEM_INFO(ARRAY array) {
            if (array == null) {
                this.triplets = new int[0];
                return;
            }
            try {
                this.triplets = array.getIntArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int[] getElements() {
            return this.triplets;
        }

        public int getSize() {
            return this.triplets.length / 3;
        }

        public int getOrdinatesOffset(int i) {
            return this.triplets[i * 3];
        }

        public void setOrdinatesOffset(int i, int offset) {
            this.triplets[i * 3] = offset;
        }

        public ElementType getElementType(int i) {
            int etype = this.triplets[i * 3 + 1];
            int interp = this.triplets[i * 3 + 2];
            ElementType et = ElementType.parseType(etype, interp);
            return et;
        }

        public boolean isCompound(int i) {
            return this.getElementType(i).isCompound();
        }

        public int getNumCompounds(int i) {
            if (this.getElementType(i).isCompound()) {
                return this.triplets[i * 3 + 2];
            }
            return 1;
        }

        public void setElement(int i, int ordinatesOffset, ElementType et, int numCompounds) {
            if (i > this.getSize()) {
                throw new RuntimeException("Attempted to set more elements in ELEM_INFO Array than capacity.");
            }
            this.triplets[i * 3] = ordinatesOffset;
            this.triplets[i * 3 + 1] = et.getEType();
            this.triplets[i * 3 + 2] = et.isCompound() ? numCompounds : et.getInterpretation();
        }

        public String toString() {
            return SDOGeometryType.arrayToString(this.triplets);
        }

        public void addElement(int[] element) {
            int[] newTriplets = new int[this.triplets.length + element.length];
            System.arraycopy(this.triplets, 0, newTriplets, 0, this.triplets.length);
            System.arraycopy(element, 0, newTriplets, this.triplets.length, element.length);
            this.triplets = newTriplets;
        }

        public void addElement(ELEM_INFO element) {
            this.addElement(element.getElements());
        }

        public int[] getElement(int i) {
            int[] ea = null;
            if (this.getElementType(i).isCompound()) {
                int numCompounds = this.getNumCompounds(i);
                ea = new int[numCompounds + 1];
            } else {
                ea = new int[3];
            }
            System.arraycopy(this.triplets, 3 * i, ea, 0, ea.length);
            return ea;
        }

        public ARRAY toOracleArray(Connection conn) throws SQLException {
            if (arrayDescriptor == null) {
                arrayDescriptor = ArrayDescriptor.createDescriptor((String)TYPE_NAME, (Connection)conn);
            } else {
                arrayDescriptor.setConnection(conn);
            }
            return new ARRAY(arrayDescriptor, conn, (Object)this.triplets);
        }
    }

    public static class SDO_POINT {
        public double x = 0.0;
        public double y = 0.0;
        public double z = Double.NaN;

        public SDO_POINT(STRUCT struct) {
            try {
                Datum[] data = struct.getOracleAttributes();
                this.x = ((NUMBER)data[0]).doubleValue();
                this.y = ((NUMBER)data[1]).doubleValue();
                if (data[2] != null) {
                    this.z = ((NUMBER)data[1]).doubleValue();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder stb = new StringBuilder();
            stb.append("(").append(this.x).append(",").append(this.y).append(",").append(this.z).append(")");
            return stb.toString();
        }
    }

    public static class SDO_GTYPE {
        private int dimension = 2;
        private int lrsDimension = 0;
        private TypeGeometry typeGeometry = TypeGeometry.UNKNOWN_GEOMETRY;

        public SDO_GTYPE(int dimension, int lrsDimension, TypeGeometry typeGeometry) {
            this.setDimension(dimension);
            this.setLrsDimension(lrsDimension);
            this.setTypeGeometry(typeGeometry);
        }

        public int getDimension() {
            return this.dimension;
        }

        public void setDimension(int dimension) {
            if (dimension < 2 || dimension > 4) {
                throw new IllegalArgumentException("Dimension can only be 2,3 or 4.");
            }
            this.dimension = dimension;
        }

        public TypeGeometry getTypeGeometry() {
            return this.typeGeometry;
        }

        public void setTypeGeometry(TypeGeometry typeGeometry) {
            this.typeGeometry = typeGeometry;
        }

        public int getLRSDimension() {
            if (this.lrsDimension > 0) {
                return this.lrsDimension;
            }
            if (this.lrsDimension == 0 && this.dimension == 4) {
                return 4;
            }
            return 0;
        }

        public int getZDimension() {
            if (this.dimension > 2) {
                if (!this.isLRSGeometry()) {
                    return this.dimension;
                }
                return this.getLRSDimension() < this.dimension ? 4 : 3;
            }
            return 0;
        }

        public boolean isLRSGeometry() {
            return this.lrsDimension > 0 || this.lrsDimension == 0 && this.dimension == 4;
        }

        public void setLrsDimension(int lrsDimension) {
            if (lrsDimension != 0 && lrsDimension > this.dimension) {
                throw new IllegalArgumentException("lrsDimension must be 0 or lower or equal to dimenstion.");
            }
            this.lrsDimension = lrsDimension;
        }

        public int intValue() {
            int v = this.dimension * 1000;
            v += this.lrsDimension * 100;
            return v += this.typeGeometry.intValue();
        }

        public static SDO_GTYPE parse(int v) {
            int dim = v / 1000;
            int lrsDim = (v -= dim * 1000) / 100;
            TypeGeometry typeGeometry = TypeGeometry.parse(v -= lrsDim * 100);
            return new SDO_GTYPE(dim, lrsDim, typeGeometry);
        }

        public static SDO_GTYPE parse(Datum datum) {
            try {
                int v = ((NUMBER)datum).intValue();
                return SDO_GTYPE.parse(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return Integer.toString(this.intValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        UNSUPPORTED(0, true),
        POINT(1, 1),
        ORIENTATION(1, 0),
        POINT_CLUSTER(1, true),
        LINE_STRAITH_SEGMENTS(2, 1),
        LINE_ARC_SEGMENTS(2, 2),
        INTERIOR_RING_STRAIGHT_SEGMENTS(2003, 1),
        EXTERIOR_RING_STRAIGHT_SEGMENTS(1003, 1),
        INTERIOR_RING_ARC_SEGMENTS(2003, 2),
        EXTERIOR_RING_ARC_SEGMENTS(1003, 2),
        INTERIOR_RING_RECT(2003, 3),
        EXTERIOR_RING_RECT(1003, 3),
        INTERIOR_RING_CIRCLE(2003, 4),
        EXTERIOR_RING_CIRCLE(1003, 4),
        COMPOUND_LINE(4, true),
        COMPOUND_EXTERIOR_RING(1005, true),
        COMPOUND_INTERIOR_RING(2005, true);

        private int etype;
        private int interpretation = 2;
        private boolean compound = false;

        private ElementType(int etype, int interp) {
            this.etype = etype;
            this.interpretation = interp;
        }

        private ElementType(int etype, boolean compound) {
            this.etype = etype;
            this.compound = compound;
        }

        public int getEType() {
            return this.etype;
        }

        public int getInterpretation() {
            return this.interpretation;
        }

        public boolean isCompound() {
            return this.compound;
        }

        public boolean isLine() {
            return this.etype == 2 || this.etype == 4;
        }

        public boolean isInteriorRing() {
            return this.etype == 2003 || this.etype == 2005;
        }

        public boolean isExteriorRing() {
            return this.etype == 1003 || this.etype == 1005;
        }

        public boolean isStraightSegment() {
            return this.interpretation == 1;
        }

        public boolean isArcSegment() {
            return this.interpretation == 2;
        }

        public boolean isCircle() {
            return this.interpretation == 4;
        }

        public boolean isRect() {
            return this.interpretation == 3;
        }

        public static ElementType parseType(int etype, int interpretation) {
            for (ElementType t : ElementType.values()) {
                if (t.etype != etype || !t.isCompound() && t.getInterpretation() != interpretation) continue;
                return t;
            }
            throw new RuntimeException("Can't determine ElementType from etype:" + etype + " and interp.:" + interpretation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeGeometry {
        UNKNOWN_GEOMETRY(0),
        POINT(1),
        LINE(2),
        POLYGON(3),
        COLLECTION(4),
        MULTIPOINT(5),
        MULTILINE(6),
        MULTIPOLYGON(7),
        SOLID(8),
        MULTISOLID(9);

        private int gtype = 0;

        private TypeGeometry(int gtype) {
            this.gtype = gtype;
        }

        int intValue() {
            return this.gtype;
        }

        static TypeGeometry parse(int v) {
            for (TypeGeometry gt : TypeGeometry.values()) {
                if (gt.intValue() != v) continue;
                return gt;
            }
            throw new RuntimeException("Value " + v + " isn't a valid TypeGeometry value");
        }
    }
}

