/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class SDOObjectProperty
implements SQLFunction {
    private final Type type;
    private final String name;

    public SDOObjectProperty(String name, Type type) {
        this.type = type;
        this.name = name;
    }

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.type == null ? columnType : this.type;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String render(List args, SessionFactoryImplementor factory) throws QueryException {
        StringBuffer buf = new StringBuffer();
        if (args.isEmpty()) {
            throw new QueryException("First Argument in arglist must be object of which property is queried");
        }
        buf.append(args.get(0)).append(".").append(this.name);
        return buf.toString();
    }
}

