/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OracleResultSetMetaData;

public class OracleResultSetMetaDataSample {
    static final String dbURI = "jdbc:oracle:thin:@oracle.geovise.com/ORCL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection conn = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            conn = DriverManager.getConnection(dbURI, "hbs", "hbs");
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * from geomtest");
            OracleResultSetMetaData rmd = (OracleResultSetMetaData)rs.getMetaData();
            if (rmd == null) {
                System.out.println("ResultSet meta data not available");
            } else {
                int columnCount = rmd.getColumnCount();
                System.out.println("Number of Columns in the table : " + columnCount);
                block12: for (int i = 1; i <= columnCount; ++i) {
                    System.out.print("Column Name :" + rmd.getColumnName(i));
                    System.out.println("   Column Type :" + rmd.getColumnTypeName(i));
                    System.out.println("Column type  = " + rmd.getColumnType(i));
                    switch (rmd.isNullable(i)) {
                        case 0: {
                            System.out.println("  NOT NULL");
                            continue block12;
                        }
                        case 1: {
                            System.out.println("  NULLABLE");
                            continue block12;
                        }
                        case 2: {
                            System.out.println("  NULLABLE Unkown");
                        }
                    }
                }
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    System.out.println("Error in closing Conection");
                }
            }
        }
    }
}

