/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import java.sql.SQLException;
import org.hibernatespatial.test.DataSourceUtils;
import org.hibernatespatial.test.SQLExpressionTemplate;

public class SDODataSourceUtils
extends DataSourceUtils {
    public SDODataSourceUtils(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPass, SQLExpressionTemplate sqlExpressionTemplate) {
        super(jdbcDriver, jdbcUrl, jdbcUser, jdbcPass, sqlExpressionTemplate);
    }

    public void afterCreateSchema() {
        super.afterCreateSchema();
        try {
            this.setGeomMetaDataTo2D();
            this.createIndex();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createIndex() throws SQLException {
        String sql = "create index idx_spatial_geomtest on geomtest (geom) indextype is mdsys.spatial_index";
        this.executeStatement(sql);
    }

    private void setGeomMetaDataTo2D() throws SQLException {
        String sql1 = "delete from user_sdo_geom_metadata where TABLE_NAME = 'GEOMTEST'";
        String sql2 = "insert into user_sdo_geom_metadata values (  'GEOMTEST',  'geom',  SDO_DIM_ARRAY(    SDO_DIM_ELEMENT('X', -180, 180, 0.00001),    SDO_DIM_ELEMENT('Y', -90, 90, 0.00001)    ),  4326)";
        this.executeStatement(sql1);
        this.executeStatement(sql2);
    }
}

