/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.oracle;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import org.hibernatespatial.oracle.SDOGeometryType;
import org.hibernatespatial.test.AbstractExpectationsFactory;
import org.hibernatespatial.test.DataSourceUtils;
import org.hibernatespatial.test.NativeSQLStatement;

public class SDOGeometryExpectationsFactory
extends AbstractExpectationsFactory {
    private final SDOGeometryType decoder = new SDOGeometryType();

    public SDOGeometryExpectationsFactory(DataSourceUtils dataSourceUtils) {
        super(dataSourceUtils);
    }

    protected NativeSQLStatement createNativeTouchesStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Touch(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Touch(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeOverlapsStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Overlap(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Overlap(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeRelateStatement(Geometry geom, String matrix) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Relate(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326), '" + matrix + "') from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Relate(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326), '" + matrix + "') = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeDwithinStatement(Point geom, double distance) {
        throw new UnsupportedOperationException();
    }

    protected NativeSQLStatement createNativeIntersectsStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Intersects(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Intersects(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeFilterStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, 1 from GEOMTEST t where SDO_FILTER(t.GEOM, MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326).GEOM)  = 'TRUE' ", geom.toText());
    }

    protected NativeSQLStatement createNativeDistanceStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Distance(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeDimensionSQL() {
        return this.createNativeSQLStatement("select ID, MDSYS.OGC_DIMENSION(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM( T.GEOM)) FROM GEOMTEST T");
    }

    protected NativeSQLStatement createNativeBufferStatement(Double distance) {
        return this.createNativeSQLStatement("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Buffer(?).GEOM from GEOMTEST T where t.GEOM.SDO_SRID = 4326", new Double[]{distance});
    }

    protected NativeSQLStatement createNativeConvexHullStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Union(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)).ST_ConvexHull().GEOM from GEOMTEST T where t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeIntersectionStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Intersection(MDSYS.ST_GEOMETRY.FROM_WKT(?,4326)).GEOM FROM GEOMTEST t where t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeDifferenceStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Difference(MDSYS.ST_GEOMETRY.FROM_WKT(?,4326)).GEOM FROM GEOMTEST t where t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeSymDifferenceStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_SymmetricDifference(MDSYS.ST_GEOMETRY.FROM_WKT(?,4326)).GEOM FROM GEOMTEST t where t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeGeomUnionStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Union(MDSYS.ST_GEOMETRY.FROM_WKT(?,4326)).GEOM FROM GEOMTEST t where t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeAsTextStatement() {
        return this.createNativeSQLStatement("select t.ID, t.GEOM.GET_WKT() FROM GEOMTEST T");
    }

    protected NativeSQLStatement createNativeSridStatement() {
        return this.createNativeSQLStatement("SELECT t.ID, t.GEOM.SDO_SRID FROM GEOMTEST t");
    }

    protected NativeSQLStatement createNativeIsSimpleStatement() {
        return this.createNativeSQLStatement("SELECT t.ID, MDSYS.OGC_ISSIMPLE(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM)) FROM GEOMTEST t where MDSYS.OGC_ISSIMPLE(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM)) = 1");
    }

    protected NativeSQLStatement createNativeIsEmptyStatement() {
        return this.createNativeSQLStatement("SELECT t.ID, MDSYS.OGC_ISEMPTY(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM)) FROM GEOMTEST t");
    }

    protected NativeSQLStatement createNativeIsNotEmptyStatement() {
        return this.createNativeSQLStatement("SELECT t.ID, CASE MDSYS.OGC_ISEMPTY(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM)) WHEN 0 THEN 1 ELSE 0 END FROM GEOMTEST t");
    }

    protected NativeSQLStatement createNativeBoundaryStatement() {
        return this.createNativeSQLStatement("SELECT t.ID, MDSYS.OGC_BOUNDARY(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM)).GEOM FROM GEOMTEST t");
    }

    protected NativeSQLStatement createNativeEnvelopeStatement() {
        return this.createNativeSQLStatement("SELECT t.ID, MDSYS.OGC_ENVELOPE(MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM)).GEOM FROM GEOMTEST t");
    }

    protected NativeSQLStatement createNativeAsBinaryStatement() {
        return this.createNativeSQLStatement("select t.ID, t.GEOM.GET_WKB() FROM GEOMTEST T");
    }

    protected NativeSQLStatement createNativeGeometryTypeStatement() {
        return this.createNativeSQLStatement("select t.id, CASE t.geom.Get_GType() WHEN 1 THEN 'POINT' WHEN 2 THEN 'LINESTRING' WHEN 3 THEN 'POLYGON' WHEN 5 THEN 'MULTIPOINT' WHEN 6 THEN 'MULTILINE' WHEN 7 THEN 'MULTIPOLYGON' END from GEOMTEST t");
    }

    protected NativeSQLStatement createNativeWithinStatement(Geometry testPolygon) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, mdsys.OGC_WITHIN( MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM), MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where mdsys.OGC_WITHIN( MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM), MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", testPolygon.toText());
    }

    protected NativeSQLStatement createNativeEqualsStatement(Geometry testPolygon) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Equals(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Equals(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", testPolygon.toText());
    }

    protected NativeSQLStatement createNativeCrossesStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Cross(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Cross(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeContainsStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Contains(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Contains(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeDisjointStatement(Geometry geom) {
        return this.createNativeSQLStatementAllWKTParams("select t.id, MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Disjoint(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) from GEOMTEST T where MDSYS.ST_GEOMETRY.FROM_SDO_GEOM(t.GEOM).ST_Disjoint(MDSYS.ST_GEOMETRY.FROM_WKT(?, 4326)) = 1 and t.GEOM.SDO_SRID = 4326", geom.toText());
    }

    protected NativeSQLStatement createNativeTransformStatement(int epsg) {
        return this.createNativeSQLStatement("select t.id, MDSYS.SDO_CS.transform(t.geom," + epsg + ") from GeomTest t where t.geom.SDO_SRID = 4326");
    }

    protected NativeSQLStatement createNativeHavingSRIDStatement(int srid) {
        return this.createNativeSQLStatement("select t.id, 1 from GeomTest t where t.geom.SDO_SRID =  " + srid);
    }

    protected Geometry decode(Object o) {
        return this.decoder.convert2JTS(o);
    }
}

