/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.hibernatespatial.HibernateSpatialException;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.cfg.GeometryFactoryHelper;
import org.hibernatespatial.cfg.HSConfiguration;
import org.hibernatespatial.helper.PropertyFileReader;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.spi.SpatialDialectProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBSpatialExtension {
    protected static Set<SpatialDialectProvider> providers;
    private static final Log log;
    private static SpatialDialect defaultSpatialDialect;
    private static final String DIALECT_PROP_NAME = "hibernate.spatial.dialect";
    private static HSConfiguration configuration;
    private static MGeometryFactory defaultGeomFactory;

    private HBSpatialExtension() {
    }

    public static void setConfiguration(HSConfiguration c) {
        SpatialDialect dialect;
        configuration = c;
        log.info((Object)("Configuring HBSpatialExtensing from " + c.getSource()));
        String dialectName = configuration.getDefaultDialect();
        if (dialectName != null && (dialect = HBSpatialExtension.createSpatialDialect(dialectName)) != null) {
            log.info((Object)("Setting Spatial Dialect to : " + dialectName));
            HBSpatialExtension.setDefaultSpatialDialect(dialect);
        }
        defaultGeomFactory = GeometryFactoryHelper.createGeometryFactory(configuration);
        log.info((Object)"Creating default Geometry Factory");
    }

    public static HSConfiguration getConfiguration() {
        return configuration;
    }

    public static void setDefaultSpatialDialect(SpatialDialect dialect) {
        defaultSpatialDialect = dialect;
    }

    public static SpatialDialect getDefaultSpatialDialect() {
        return defaultSpatialDialect;
    }

    public static SpatialDialect createSpatialDialect(String dialectName) {
        SpatialDialectProvider provider;
        SpatialDialect dialect = null;
        Iterator<SpatialDialectProvider> i$ = providers.iterator();
        while (i$.hasNext() && (dialect = (provider = i$.next()).createSpatialDialect(dialectName)) == null) {
        }
        if (dialect == null) {
            throw new HibernateSpatialException("No SpatialDialect provider for persistenceUnit " + dialectName);
        }
        return dialect;
    }

    public static MGeometryFactory getDefaultGeomFactory() {
        return defaultGeomFactory;
    }

    private static Set<String> providerNamesFromReader(InputStream is) throws IOException {
        PropertyFileReader reader = new PropertyFileReader(is);
        return reader.getNonCommentLines();
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

