/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.cfg.Configuration;
import org.hibernatespatial.cfg.HSProperty;

public class HSConfiguration
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(HSConfiguration.class);
    private String source;
    private HSProperty[] HSProperties = HSProperty.values();

    public String getDefaultDialect() {
        return this.getProperty(HSProperty.DEFAULT_DIALECT.toString());
    }

    public void setDefaultDialect(String dialect) {
        this.setProperty(HSProperty.DEFAULT_DIALECT, dialect);
    }

    public String getPrecisionModel() {
        return this.getProperty(HSProperty.PRECISION_MODEL.toString());
    }

    public void setPrecisionModel(String precisionModel) {
        this.setProperty(HSProperty.PRECISION_MODEL, precisionModel);
    }

    public String getProperty(HSProperty property) {
        return this.getProperty(property.toString());
    }

    public void setProperty(HSProperty property, String value) {
        this.setProperty(property.toString(), value);
    }

    public HSConfiguration configure(Configuration hibernateConfig) {
        String dialect = hibernateConfig.getProperty("hibernate.dialect");
        this.setProperty(HSProperty.DEFAULT_DIALECT, dialect);
        return this;
    }

    public HSConfiguration configure() {
        return this.configure("hibernate-spatial.cfg.xml");
    }

    public HSConfiguration configure(File resource) {
        this.source = resource.getName();
        logger.info((Object)("configuring from file: " + resource.getName()));
        try {
            return this.doConfigure(new FileInputStream(resource));
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)("could not find file: " + resource + ".\nCause:" + e.getMessage()));
        }
        catch (DocumentException e) {
            logger.warn((Object)("Failed to load configuration file :" + resource + ".\nCause:" + e.getMessage()));
        }
        return null;
    }

    public String getSource() {
        return this.source;
    }

    public HSConfiguration configure(String resource) {
        logger.info((Object)("configuring from resource: " + resource));
        this.source = resource;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = null;
        try {
            stream = classLoader.getResourceAsStream(resource);
            return this.doConfigure(stream);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to load configuration file :" + resource));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSConfiguration doConfigure(InputStream stream) throws DocumentException {
        try {
            SAXReader reader = new SAXReader();
            Document configDoc = reader.read(stream);
            Element root = configDoc.getRootElement();
            for (HSProperty hsprop : this.HSProperties) {
                Element propEl = root.element(hsprop.toString().toLowerCase());
                if (propEl == null) continue;
                this.setProperty(hsprop, propEl.getText());
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        return this;
    }
}

