/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import org.hibernatespatial.mgeom.DoubleComparator;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MCoordinateSequence;
import org.hibernatespatial.mgeom.MGeometry;
import org.hibernatespatial.mgeom.MGeometryException;

public class MLineString
extends LineString
implements MGeometry {
    private static final long serialVersionUID = 1L;
    private boolean monotone = false;
    private boolean strictMonotone = false;

    public MLineString(CoordinateSequence points, GeometryFactory factory) {
        super(points, factory);
        this.determineMonotone();
    }

    public Object clone() {
        LineString ls = (LineString)super.clone();
        return new MLineString(ls.getCoordinateSequence(), this.getFactory());
    }

    private void determineMonotone() {
        this.monotone = true;
        this.strictMonotone = true;
        if (!this.isEmpty()) {
            double[] m = this.getMeasures();
            if (Double.isNaN(m[0])) {
                this.monotone = false;
                this.strictMonotone = false;
            } else {
                int result = 0;
                int prevResult = 0;
                for (int i = 1; i < m.length && this.monotone; ++i) {
                    result = Double.compare(m[i - 1], m[i]);
                    this.monotone = result * prevResult >= 0 && !Double.isNaN(m[i]);
                    this.strictMonotone &= this.monotone && result != 0;
                    prevResult = result;
                }
            }
        }
        assert (!this.strictMonotone || this.monotone);
    }

    protected void geometryChangedAction() {
        this.determineMonotone();
    }

    public MCoordinate getClosestPoint(Coordinate co, double tolerance) throws MGeometryException {
        if (!this.isMonotone(false)) {
            throw new MGeometryException(1);
        }
        if (!this.isEmpty()) {
            LineSegment seg = new LineSegment();
            Coordinate[] coAr = this.getCoordinates();
            seg.p0 = coAr[0];
            double d = 0.0;
            double projfact = 0.0;
            double minDist = Double.POSITIVE_INFINITY;
            MCoordinate mincp = null;
            for (int i = 1; i < coAr.length; ++i) {
                seg.p1 = coAr[i];
                Coordinate cp = seg.closestPoint(co);
                d = cp.distance(co);
                if (d <= tolerance && d <= minDist) {
                    MCoordinate testcp = new MCoordinate(cp);
                    projfact = seg.projectionFactor(cp);
                    testcp.m = ((MCoordinate)coAr[i - 1]).m + projfact * (((MCoordinate)coAr[i]).m - ((MCoordinate)coAr[i - 1]).m);
                    if (d < minDist || testcp.m < mincp.m) {
                        mincp = testcp;
                        minDist = d;
                    }
                }
                seg.p0 = seg.p1;
            }
            if (minDist > tolerance) {
                return null;
            }
            return mincp;
        }
        return null;
    }

    public Coordinate getCoordinateAtM(double m) throws MGeometryException {
        if (!this.isMonotone(false)) {
            throw new MGeometryException(1);
        }
        if (this.isEmpty()) {
            return null;
        }
        double[] mval = this.getMeasures();
        double lb = this.getMinM();
        double up = this.getMaxM();
        if (m < lb || m > up) {
            return null;
        }
        for (int i = 1; i < mval.length; ++i) {
            if (!(mval[i - 1] <= m && m <= mval[i]) && (!(mval[i] <= m) || !(m <= mval[i - 1]))) continue;
            MCoordinate p0 = (MCoordinate)this.getCoordinateN(i - 1);
            MCoordinate p1 = (MCoordinate)this.getCoordinateN(i);
            double r = (m - mval[i - 1]) / (mval[i] - mval[i - 1]);
            double dx = r * (p1.x - p0.x);
            double dy = r * (p1.y - p0.y);
            double dz = r * (p1.z - p0.z);
            MCoordinate nc = new MCoordinate(p0.x + dx, p0.y + dy, p0.z + dz, m);
            return nc;
        }
        return null;
    }

    public String getGeometryType() {
        return "MLineString";
    }

    public double getMatCoordinate(Coordinate c, double tolerance) throws MGeometryException {
        MCoordinate mco = this.getClosestPoint(c, tolerance);
        if (mco == null) {
            return Double.NaN;
        }
        return mco.m;
    }

    public double getMatN(int n) {
        return ((MCoordinate)this.getCoordinates()[n]).m;
    }

    public double getMaxM() {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        double[] measures = this.getMeasures();
        if (this.getMeasureDirection() == 1) {
            return measures[measures.length - 1];
        }
        if (this.getMeasureDirection() == -1 || this.getMeasureDirection() == 0) {
            return measures[0];
        }
        double ma = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < measures.length; ++i) {
            if (!(ma < measures[i])) continue;
            ma = measures[i];
        }
        return ma;
    }

    public CoordinateSequence[] getCoordinatesBetween(double fromM, double toM) throws MGeometryException {
        double up;
        if (!this.isMonotone(false)) {
            throw new MGeometryException(1);
        }
        if (this.isEmpty() || !this.isMonotone(false)) {
            return new MCoordinateSequence[0];
        }
        double[] mval = this.getMeasures();
        double lb = Math.min(mval[0], mval[mval.length - 1]);
        fromM = Math.max(lb, Math.min(fromM, up = Math.max(mval[0], mval[mval.length - 1])));
        if (DoubleComparator.equals(fromM, toM = Math.max(lb, Math.min(toM, up)))) {
            return new MCoordinateSequence[0];
        }
        Coordinate[] mcoords = (MCoordinate[])this.getCoordinates();
        if (this.getMeasureDirection() == -1) {
            CoordinateArrays.reverse((Coordinate[])mcoords);
        }
        double minM = Math.min(fromM, toM);
        double maxM = Math.max(fromM, toM);
        ArrayList<Coordinate> mcolist = new ArrayList<Coordinate>();
        for (int i = 0; i < mcoords.length; ++i) {
            MCoordinate mc;
            double r;
            Coordinate mco1;
            Coordinate mco2;
            if (mcolist.isEmpty() && mcoords[i].m >= minM) {
                mco2 = mcoords[i];
                if (DoubleComparator.equals(mcoords[i].m, minM)) {
                    mcolist.add(mco2);
                    continue;
                }
                mco1 = mcoords[i - 1];
                r = (minM - mco1.m) / (mco2.m - mco1.m);
                assert (DoubleComparator.equals(mco1.m + r * (mco2.m - mco1.m), minM)) : "Error on assumption on r";
                mc = new MCoordinate(mco1.x + r * (mco2.x - mco1.x), mco1.y + r * (mco2.y - mco1.y), mco1.z + r * (mco2.z - mco1.z), minM);
                mcolist.add(mc);
                continue;
            }
            if (mcoords[i].m >= minM && mcoords[i].m <= maxM) {
                mcolist.add(mcoords[i]);
                if (!DoubleComparator.equals(mcoords[i].m, maxM)) continue;
                break;
            }
            if (!(mcoords[i].m > maxM)) continue;
            assert (i > 0) : "mistaken assumption";
            mco2 = mcoords[i];
            mco1 = mcoords[i - 1];
            r = (maxM - mco1.m) / (mco2.m - mco1.m);
            mc = new MCoordinate(mco1.x + r * (mco2.x - mco1.x), mco1.y + r * (mco2.y - mco1.y), mco1.z + r * (mco2.z - mco1.z), maxM);
            mcolist.add(mc);
            break;
        }
        Coordinate[] h = new MCoordinate[mcolist.size()];
        for (int i = 0; i < mcolist.size(); ++i) {
            h[i] = (MCoordinate)((Object)mcolist.get(i));
        }
        if (!DoubleComparator.equals(minM, fromM)) {
            CoordinateArrays.reverse((Coordinate[])h);
        }
        MCoordinateSequence mc = new MCoordinateSequence((MCoordinate[])h);
        return new MCoordinateSequence[]{mc};
    }

    public int getMeasureDirection() {
        if (!this.monotone) {
            return -3;
        }
        MCoordinate c1 = (MCoordinate)this.getCoordinateN(0);
        MCoordinate c2 = (MCoordinate)this.getCoordinateN(this.getNumPoints() - 1);
        if (c1.m < c2.m) {
            return 1;
        }
        if (c1.m > c2.m) {
            return -1;
        }
        return 0;
    }

    public double[] getMeasures() {
        if (!this.isEmpty()) {
            Coordinate[] co = this.getCoordinates();
            double[] a = new double[co.length];
            for (int i = 0; i < co.length; ++i) {
                a[i] = ((MCoordinate)co[i]).m;
            }
            return a;
        }
        return null;
    }

    public double getMinM() {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        double[] a = this.getMeasures();
        if (this.getMeasureDirection() == 1) {
            return a[0];
        }
        if (this.getMeasureDirection() == -1 || this.getMeasureDirection() == 0) {
            return a[a.length - 1];
        }
        double ma = Double.POSITIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!(ma > a[i])) continue;
            ma = a[i];
        }
        return ma;
    }

    public void interpolate(double beginMeasure, double endMeasure) {
        if (this.isEmpty()) {
            return;
        }
        Coordinate[] coordinates = this.getCoordinates();
        double length = this.getLength();
        double mLength = endMeasure - beginMeasure;
        double d = 0.0;
        boolean continuous = DoubleComparator.equals(beginMeasure, endMeasure);
        double m = beginMeasure;
        MCoordinate prevCoord = MCoordinate.convertCoordinate(coordinates[0]);
        prevCoord.m = m;
        for (int i = 1; i < coordinates.length; ++i) {
            MCoordinate curCoord = MCoordinate.convertCoordinate(coordinates[i]);
            if (continuous) {
                curCoord.m = beginMeasure;
                continue;
            }
            curCoord.m = m = beginMeasure + (d += curCoord.distance(prevCoord)) / length * mLength;
            prevCoord = curCoord;
        }
        this.geometryChanged();
        assert (this.isMonotone(false)) : "interpolate function should always leave MGeometry monotone";
    }

    public double getMLength() {
        if (this.getCoordinateSequence().size() == 0) {
            return Double.NaN;
        }
        if (this.getCoordinateSequence().size() == 1) {
            return 0.0;
        }
        int lastIndex = this.getCoordinateSequence().size() - 1;
        double begin = this.getCoordinateSequence().getOrdinate(0, 3);
        double end = this.getCoordinateSequence().getOrdinate(lastIndex, 3);
        return Double.isNaN(begin) || Double.isNaN(end) ? Double.NaN : Math.abs(end - begin);
    }

    public boolean isMonotone(boolean strict) {
        return strict ? this.strictMonotone : this.monotone;
    }

    public void measureOnLength(boolean keepBeginMeasure) {
        Coordinate[] co = this.getCoordinates();
        if (!this.isEmpty()) {
            double d = 0.0;
            MCoordinate pco = (MCoordinate)co[0];
            if (!keepBeginMeasure || Double.isNaN(pco.m)) {
                pco.m = 0.0;
            }
            for (int i = 1; i < co.length; ++i) {
                MCoordinate mco = (MCoordinate)co[i];
                mco.m = d += mco.distance(pco);
                pco = mco;
            }
            this.geometryChanged();
        }
    }

    public void reverseMeasures() {
        if (!this.isEmpty()) {
            double[] m = this.getMeasures();
            MCoordinate[] coar = (MCoordinate[])this.getCoordinates();
            for (int i = 0; i < m.length; ++i) {
                double nv;
                coar[i].m = nv = m[m.length - 1 - i];
            }
            this.geometryChanged();
        }
    }

    public void setMeasureAtIndex(int index, double m) {
        this.getCoordinateSequence().setOrdinate(index, 3, m);
        this.geometryChanged();
    }

    public void shiftMeasure(double amount) {
        Coordinate[] coordinates = this.getCoordinates();
        if (!this.isEmpty()) {
            for (int i = 0; i < coordinates.length; ++i) {
                MCoordinate mco = (MCoordinate)coordinates[i];
                mco.m += amount;
            }
        }
        this.geometryChanged();
    }

    public String toString() {
        Coordinate[] ar = this.getCoordinates();
        StringBuffer buf = new StringBuffer(ar.length * 17 * 3);
        for (int i = 0; i < ar.length; ++i) {
            buf.append(ar[i].x);
            buf.append(" ");
            buf.append(ar[i].y);
            buf.append(" ");
            buf.append(((MCoordinate)ar[i]).m);
            buf.append("\n");
        }
        return buf.toString();
    }

    public MLineString unionM(MLineString l) throws MGeometryException {
        if (!this.monotone || !l.monotone) {
            throw new MGeometryException(1);
        }
        Coordinate[] linecoar = l.getCoordinates();
        if (l.getMeasureDirection() == -1) {
            CoordinateArrays.reverse((Coordinate[])linecoar);
        }
        Coordinate[] thiscoar = this.getCoordinates();
        if (this.getMeasureDirection() == -1) {
            CoordinateArrays.reverse((Coordinate[])thiscoar);
        }
        MCoordinate lasttco = (MCoordinate)thiscoar[thiscoar.length - 1];
        MCoordinate firsttco = (MCoordinate)thiscoar[0];
        MCoordinate lastlco = (MCoordinate)linecoar[linecoar.length - 1];
        MCoordinate firstlco = (MCoordinate)linecoar[0];
        Coordinate[] newcoar = new MCoordinate[thiscoar.length + linecoar.length - 1];
        if (lasttco.equals2D(firstlco) && DoubleComparator.equals(lasttco.m, firstlco.m)) {
            System.arraycopy(thiscoar, 0, newcoar, 0, thiscoar.length);
            System.arraycopy(linecoar, 1, newcoar, thiscoar.length, linecoar.length - 1);
        } else if (lastlco.equals2D(firsttco) && DoubleComparator.equals(lastlco.m, firsttco.m)) {
            System.arraycopy(linecoar, 0, newcoar, 0, linecoar.length);
            System.arraycopy(thiscoar, 1, newcoar, linecoar.length, thiscoar.length - 1);
        } else {
            throw new MGeometryException(2);
        }
        CoordinateSequence mcs = this.getFactory().getCoordinateSequenceFactory().create(newcoar);
        MLineString returnmlinestring = new MLineString(mcs, this.getFactory());
        assert (returnmlinestring.isMonotone(false)) : "new unionM-ed MLineString is not monotone";
        return returnmlinestring;
    }
}

