/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.Serializable;
import junit.framework.TestCase;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.cfg.HSConfiguration;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.mgeom.MLineString;
import org.hibernatespatial.mgeom.MultiMLineString;
import org.hibernatespatial.test.model.LineStringEntity;
import org.hibernatespatial.test.model.MLineStringEntity;
import org.hibernatespatial.test.model.MultiLineStringEntity;
import org.hibernatespatial.test.model.MultiMLineStringEntity;
import org.hibernatespatial.test.model.PointEntity;
import org.hibernatespatial.test.model.PolygonEntity;

public class TestCRUD
extends TestCase {
    private SessionFactory factory;
    private static final int COORDARRAY_LENGTH = 100;
    private MGeometryFactory geomFactory = new MGeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 31370);

    public void setUpBeforeClass() throws Exception {
        try {
            System.out.println("Setting up Hibernate");
            Configuration config = new Configuration();
            config.configure();
            config.addClass(LineStringEntity.class);
            config.addClass(PolygonEntity.class);
            config.addClass(MultiLineStringEntity.class);
            config.addClass(PointEntity.class);
            config.addClass(MLineStringEntity.class);
            config.addClass(MultiMLineStringEntity.class);
            HSConfiguration hsc = new HSConfiguration();
            hsc.configure(config);
            HBSpatialExtension.setConfiguration((HSConfiguration)hsc);
            this.factory = config.buildSessionFactory();
        }
        catch (Exception e) {
            System.err.println("Failed to configure Hibernate." + e.getMessage());
            throw e;
        }
        System.out.println("Hibernate set-up complete.");
    }

    public void tearDownAfterClass() {
        this.factory.close();
        this.factory = null;
    }

    private long saveObject(Object obj) throws Exception {
        Session session = this.factory.openSession();
        Transaction tx = null;
        long id = -1L;
        try {
            tx = session.beginTransaction();
            session.save(obj);
            if (obj instanceof LineStringEntity) {
                id = ((LineStringEntity)obj).getId();
            } else if (obj instanceof PointEntity) {
                id = ((PointEntity)obj).getId();
            } else if (obj instanceof MLineStringEntity) {
                id = ((MLineStringEntity)obj).getId();
            } else if (obj instanceof MultiMLineStringEntity) {
                id = ((MultiMLineStringEntity)obj).getId();
            } else {
                throw new RuntimeException("can't save object of this type");
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            session.close();
        }
        return id;
    }

    private Object retrieveObject(Class clazz, long id) {
        Session session = this.factory.openSession();
        Object obj = session.get(clazz, (Serializable)Long.valueOf(id));
        session.close();
        return obj;
    }

    public void testSaveLineStringEntity() throws Exception {
        this.testSaveLineStringEntity(2);
    }

    public void testSaveLineStringEntity(int dim) throws Exception {
        LineStringEntity line = new LineStringEntity();
        Coordinate[] coordinates = new Coordinate[100];
        double startx = 4319.0;
        double starty = 53255.0;
        double startz = 125.0;
        for (int i = 0; i < 100; ++i) {
            if (dim == 2) {
                coordinates[i] = new Coordinate(startx + (double)i, starty + (double)i);
                continue;
            }
            if (dim == 3) {
                coordinates[i] = new Coordinate(startx + (double)i, starty + (double)i, startz + (double)i);
                continue;
            }
            throw new RuntimeException("Dimension not supported.");
        }
        LineString geom = this.geomFactory.createLineString(coordinates);
        line.setGeometry((Geometry)geom);
        line.setName("Added by TestCRUD");
        long id = this.saveObject(line);
        LineStringEntity retrieved = (LineStringEntity)this.retrieveObject(LineStringEntity.class, id);
        TestCRUD.assertTrue((boolean)line.getGeometry().equals(retrieved.getGeometry()));
        TestCRUD.assertEquals((long)line.getId(), (long)retrieved.getId());
        TestCRUD.assertEquals((String)line.getName(), (String)retrieved.getName());
    }

    private MLineString createMLineString(double startx, double starty, double startz, double startm) {
        MCoordinate[] coordinates = new MCoordinate[100];
        for (int i = 0; i < 100; ++i) {
            coordinates[i] = new MCoordinate(startx + (double)i, starty + (double)i, startz + (double)i, startm + (double)i);
        }
        MLineString geom = this.geomFactory.createMLineString(coordinates);
        return geom;
    }

    private void assertEquality(Geometry expected, Geometry retrieved) {
        TestCRUD.assertTrue((boolean)expected.equals(retrieved));
        Coordinate[] rCoords = retrieved.getCoordinates();
        Coordinate[] eCoords = expected.getCoordinates();
        for (int idx = 0; idx < rCoords.length; ++idx) {
            MCoordinate rco = (MCoordinate)rCoords[idx];
            MCoordinate eco = (MCoordinate)eCoords[idx];
            TestCRUD.assertEquals((String)"z value not equal", (double)eco.z, (double)rco.z, (double)1.0E-6);
            TestCRUD.assertEquals((String)"m value not equal", (double)eco.z, (double)rco.z, (double)1.0E-6);
        }
    }

    public void testSaveMLineStringEntity() throws Exception {
        MLineStringEntity mline = new MLineStringEntity();
        double startx = 4319.0;
        double starty = 53255.0;
        double startz = 125.0;
        double startm = 0.0;
        MLineString geom = this.createMLineString(startx, starty, startz, startm);
        mline.setGeometry(geom);
        mline.setName("Added by TestCRUD");
        long id = this.saveObject(mline);
        MLineStringEntity retrieved = (MLineStringEntity)this.retrieveObject(MLineStringEntity.class, id);
        this.assertEquality((Geometry)geom, retrieved.getGeometry());
        TestCRUD.assertEquals((long)mline.getId(), (long)retrieved.getId());
        TestCRUD.assertEquals((String)mline.getName(), (String)retrieved.getName());
    }

    public void testSaveMultiMLineStringEntity() throws Exception {
        MultiMLineStringEntity entity = new MultiMLineStringEntity();
        double startx = 4000.0;
        double starty = 4000.0;
        double startz = 10.0;
        double startm = 0.0;
        MLineString[] mlines = new MLineString[5];
        for (int i = 0; i < 5; ++i) {
            mlines[i] = this.createMLineString(startx += (double)(i * 100) + 10.0, starty += (double)(i * 100) + 10.0, startz += (double)(i * 100) + 10.0, startm += (double)(i * 100));
        }
        MultiMLineString multiMLine = this.geomFactory.createMultiMLineString(mlines);
        entity.setGeometry(multiMLine);
        entity.setName("Added by TestCRUD");
        long id = this.saveObject(entity);
        MultiMLineStringEntity retrievedEntity = (MultiMLineStringEntity)this.retrieveObject(MultiMLineStringEntity.class, id);
        MultiMLineString retrievedGeom = (MultiMLineString)retrievedEntity.getGeometry();
        for (int i = 0; i < retrievedGeom.getNumGeometries(); ++i) {
            this.assertEquality(multiMLine.getGeometryN(i), retrievedGeom.getGeometryN(i));
        }
        TestCRUD.assertEquals((long)entity.getId(), (long)retrievedEntity.getId());
        TestCRUD.assertEquals((String)entity.getName(), (String)retrievedEntity.getName());
    }

    public void testSaveNullLineStringEntity() throws Exception {
        LineStringEntity line = new LineStringEntity();
        line.setGeometry(null);
        line.setName("Null geom Added by TestCRUD");
        long id = this.saveObject(line);
        LineStringEntity retrieved = (LineStringEntity)this.retrieveObject(LineStringEntity.class, id);
        TestCRUD.assertNull((Object)retrieved.getGeometry());
    }

    public void testSavePoint(int dim) throws Exception {
        double x = 4319.0;
        double y = 53255.0;
        double z = 125.0;
        Coordinate c = null;
        switch (dim) {
            case 2: {
                c = new Coordinate(x, y);
                break;
            }
            case 3: {
                c = new Coordinate(x, y, z);
                break;
            }
            default: {
                throw new RuntimeException("Dimension not supported.");
            }
        }
        PointEntity pt = new PointEntity();
        Point geom = this.geomFactory.createPoint(c);
        geom.setSRID(31370);
        pt.setGeometry((Geometry)geom);
        pt.setName("Added by TestCRUD");
        long id = this.saveObject(pt);
        PointEntity retrieved = (PointEntity)this.retrieveObject(PointEntity.class, id);
        TestCRUD.assertTrue((boolean)pt.getGeometry().equals(retrieved.getGeometry()));
        TestCRUD.assertEquals((long)pt.getId(), (long)retrieved.getId());
        TestCRUD.assertEquals((String)pt.getName(), (String)retrieved.getName());
    }
}

