/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernatespatial.GeometryUserType;
import org.hibernatespatial.criterion.SpatialProjections;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.hibernatespatial.test.model.LineStringEntity;
import org.hibernatespatial.test.model.MultiLineStringEntity;
import org.hibernatespatial.test.model.PolygonEntity;
import org.junit.Assert;

public class TestSpatialQueries {
    private static final String MODEL_PACKAGE = "org.hibernatespatial.test.model";
    private static final Log log = LogFactory.getLog((String)TestSpatialQueries.class.getCanonicalName());
    private SessionFactory factory;
    private Connection conn;
    private Geometry jtsFilter = null;
    private String filterPolygonString = "POLYGON((0.0 0.0, 25000.0 0.0, 25000.0 25000.0, 0.0 25000.0, 0.0 0.0))";
    private static final String[] entities = new String[]{"LineStringEntity", "PolygonEntity", "MLineStringEntity"};
    private static final String[] tables = new String[]{"linestringtest", "polygontest", "mlinestringtest"};

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public void setUpBeforeClass(Connection conn) throws SQLException, ClassNotFoundException, ParseException {
        if (conn == null) {
            throw new RuntimeException("Empty connection passed.");
        }
        this.conn = conn;
        Configuration config = new Configuration();
        config.configure();
        config.addClass(LineStringEntity.class);
        config.addClass(PolygonEntity.class);
        config.addClass(MultiLineStringEntity.class);
        this.factory = config.buildSessionFactory();
        WKTReader reader = new WKTReader();
        this.jtsFilter = reader.read(this.filterPolygonString);
        this.jtsFilter.setSRID(31370);
    }

    public void tearDownAfterClass() {
        this.factory.close();
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void testHQL(String func, String sqlTemplate, int numArgs) throws Exception {
        for (int i = 0; i < entities.length; ++i) {
            String entity = entities[i];
            String table = tables[i];
            String sqlString = sqlTemplate.replaceAll("\\$table\\$", table);
            log.info((Object)("Testing operator " + func + " for " + entity));
            this.testHQL(func, entity, sqlString, numArgs);
        }
    }

    private void testHQL(String f, String entity, String sqlString, int numArgs) throws Exception {
        org.hibernate.classic.Session session = null;
        if (numArgs < 1 || numArgs > 2) {
            throw new IllegalArgumentException("Only one or two arguments accepted in HQL function");
        }
        String funcStr = f + "( l.geometry ";
        for (int i = numArgs; i > 1; --i) {
            funcStr = funcStr + ", ?";
        }
        funcStr = funcStr + ")";
        String queryStr = "select " + funcStr + " from " + entity + " as l where l.geometry is not null ";
        try {
            session = this.factory.openSession();
            Query q = session.createQuery(queryStr);
            CustomType geometryType = new CustomType(GeometryUserType.class, null);
            if (numArgs > 1) {
                q.setParameter(0, (Object)this.jtsFilter, (Type)geometryType);
            }
            int cases = 0;
            for (Boolean b : q.list()) {
                if (!b.booleanValue()) continue;
                ++cases;
            }
            PreparedStatement stmt = this.conn.prepareStatement(sqlString);
            if (numArgs > 1) {
                stmt.setString(1, this.filterPolygonString);
            }
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int expected = rs.getInt(1);
            Assert.assertEquals((Object)expected, (Object)cases);
            log.info((Object)("num. " + f + " for table " + entity + " = " + cases));
            Query q2 = session.createQuery("from " + entity + " as l where l.geometry is not null and " + funcStr + " = True");
            if (numArgs > 1) {
                q2.setParameter(0, (Object)this.jtsFilter, (Type)geometryType);
            }
            List l = q2.list();
            Assert.assertEquals((Object)expected, (Object)l.size());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRelation(int relation, Class entityClass, String sql) throws Exception {
        org.hibernate.classic.Session session = null;
        try {
            session = this.factory.openSession();
            Criteria testCriteria = session.createCriteria(entityClass);
            testCriteria.add(SpatialRestrictions.spatialRestriction((int)relation, (String)"geometry", (Geometry)this.jtsFilter));
            List results = testCriteria.list();
            log.debug((Object)("Test SQL:" + sql));
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            ParameterMetaData metadata = stmt.getParameterMetaData();
            for (int i = 1; i <= metadata.getParameterCount(); ++i) {
                stmt.setString(i, this.filterPolygonString);
            }
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int expected = rs.getInt(1);
            Assert.assertEquals((Object)expected, (Object)results.size());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void testRelation(int relation, String sqlTemplate) throws Exception {
        for (int i = 0; i < entities.length; ++i) {
            String sql = sqlTemplate.replaceAll("\\$table\\$", tables[i]);
            Class<?> entityClass = Class.forName("org.hibernatespatial.test.model." + entities[i]);
            this.testRelation(relation, entityClass, sql);
        }
    }

    public void testExtent(String sqlTemplate) throws Exception {
        for (int i = 0; i < entities.length; ++i) {
            String sql = sqlTemplate.replaceAll("\\$table\\$", tables[i]);
            Class<?> entityClass = Class.forName("org.hibernatespatial.test.model." + entities[i]);
            this.testExtent(entityClass, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExtent(Class entityClass, String sql) throws Exception {
        org.hibernate.classic.Session session = null;
        try {
            session = this.factory.openSession();
            Criteria testCriteria = session.createCriteria(entityClass).setProjection(SpatialProjections.extent((String)"geometry"));
            List results = testCriteria.list();
            Geometry g = (Geometry)results.get(0);
            double area = g.getArea();
            log.debug((Object)("Test SQL:" + sql));
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            double expected = rs.getDouble(1);
            log.info((Object)("Comparing extent areas. Expected: " + expected + ", result :" + area));
            Assert.assertEquals((double)expected, (double)area, (double)0.1);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void testFiltering(String sqlTemplate) throws Exception {
        this.testRelation(8, sqlTemplate);
    }

    public void testContains(String sqlTemplate) throws Exception {
        this.testRelation(6, sqlTemplate);
    }

    public void testCrosses(String sqlTemplate) throws Exception {
        this.testRelation(3, sqlTemplate);
    }

    public void testDisjoint(String sqlTemplate) throws Exception {
        this.testRelation(1, sqlTemplate);
    }

    public void testEquals(String sqlTemplate) throws Exception {
        this.testRelation(0, sqlTemplate);
    }

    public void testIntersects(String sqlTemplate) throws Exception {
        this.testRelation(7, sqlTemplate);
    }

    public void testOverlaps(String sqlTemplate) throws Exception {
        this.testRelation(5, sqlTemplate);
    }

    public void testTouches(String sqlTemplate) throws Exception {
        this.testRelation(2, sqlTemplate);
    }

    public void testWithin(String sqlTemplate) throws Exception {
        this.testRelation(4, sqlTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHQLAsText(String entity) throws Exception {
        org.hibernate.classic.Session session = null;
        WKTReader reader = new WKTReader();
        try {
            session = this.factory.openSession();
            Query q = session.createQuery("select astext(l.geometry), l.geometry  from " + entity + " as l");
            Iterator it = q.list().iterator();
            for (int i = 0; it.hasNext() && i < 10; ++i) {
                Object[] row = (Object[])it.next();
                String text = (String)row[0];
                Geometry expected = (Geometry)row[1];
                Geometry geom = reader.read(text);
                Assert.assertTrue((boolean)expected.equalsExact(geom, 0.1));
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void testHQLAsText() throws Exception {
        for (String entity : entities) {
            log.info((Object)("Testing AsText for " + entity));
            this.testHQLAsText(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHQLAsBinary(String entity) throws Exception {
        org.hibernate.classic.Session session = null;
        WKBReader reader = new WKBReader();
        try {
            session = this.factory.openSession();
            Query q = session.createQuery("select asbinary(l.geometry), l.geometry  from " + entity + " as l");
            Iterator it = q.list().iterator();
            for (int i = 0; it.hasNext() && i < 10; ++i) {
                Object[] row = (Object[])it.next();
                byte[] bytes = (byte[])row[0];
                Geometry expected = (Geometry)row[1];
                Geometry geom = reader.read(bytes);
                Assert.assertTrue((boolean)expected.equalsExact(geom, 0.1));
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void testHQLAsBinary() throws Exception {
        for (String entity : entities) {
            log.info((Object)("Testing AsBinary for " + entity));
            this.testHQLAsBinary(entity);
        }
    }

    public void testHQLExtent(String sqlTemplate) throws Exception {
        for (int i = 0; i < entities.length; ++i) {
            String sql = sqlTemplate.replaceAll("\\$table\\$", tables[i]);
            Class<?> entityClass = Class.forName("org.hibernatespatial.test.model." + entities[i]);
            this.testHQLExtent(entityClass, sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHQLExtent(Class entityClass, String sql) throws Exception {
        org.hibernate.classic.Session session = null;
        try {
            session = this.factory.openSession();
            Query query = session.createQuery("select extent(geometry) from " + entityClass.getSimpleName());
            Geometry g = (Geometry)query.list().get(0);
            double area = g.getArea();
            log.debug((Object)("Test SQL:" + sql));
            PreparedStatement stmt = this.conn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            double expected = rs.getDouble(1);
            log.info((Object)("Comparing extent areas. Expected: " + expected + ", result :" + area));
            Assert.assertEquals((double)expected, (double)area, (double)0.1);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void testHQLDimension() throws Exception {
        Integer dim;
        int i;
        org.hibernate.classic.Session session = this.factory.openSession();
        Query q = session.createQuery("select dimension(l.geometry) from LineStringEntity as l where l.geometry is not null");
        Iterator it = q.list().iterator();
        for (i = 0; it.hasNext() && i < 10; ++i) {
            dim = (Integer)it.next();
            Assert.assertEquals((Object)new Integer(1), (Object)dim);
        }
        q = session.createQuery("select dimension(p.geometry) from PolygonEntity as p where p.geometry is not null");
        it = q.list().iterator();
        for (i = 0; it.hasNext() && i < 10; ++i) {
            dim = (Integer)it.next();
            Assert.assertEquals((Object)new Integer(2), (Object)dim);
        }
        session.close();
    }

    public void testHQLOverlaps(String sqlTemplate) throws Exception {
        this.testHQL("overlaps", sqlTemplate, 2);
    }

    public void testHQLRelateLineString() throws Exception {
        org.hibernate.classic.Session session = this.factory.openSession();
        Query q = session.createQuery("select count(*) from LineStringEntity l where relate(l.geometry, ?, 'TT*******') = true and l.geometry is not null");
        CustomType geometryType = new CustomType(GeometryUserType.class, null);
        q.setParameter(0, (Object)this.jtsFilter, (Type)geometryType);
        Long cnt = (Long)q.list().get(0);
        System.out.println("Related by 'TT*******' pattern = " + cnt);
    }

    public void testHQLIntersectsLineString(String sqlString) throws Exception {
        this.testHQL("intersects", sqlString, 2);
    }

    public void testHQLSRID() throws Exception {
        org.hibernate.classic.Session session = this.factory.openSession();
        Query q = session.createQuery("select srid(l.geometry) from LineStringEntity as l where l.geometry is not null");
        int i = 0;
        for (Integer srid : q.list()) {
            Assert.assertEquals((Object)31370, (Object)srid);
            ++i;
        }
        session.close();
    }

    public void testHQLGeometryType() throws Exception {
        System.out.println("Testing GeometryType");
        org.hibernate.classic.Session session = this.factory.openSession();
        Query q = session.createQuery("select geometrytype(l.geometry) from LineStringEntity as l where l.geometry is not null");
        int i = 0;
        for (String gt : q.list()) {
            Assert.assertEquals((Object)"LINESTRING", (Object)gt);
            ++i;
        }
        q = session.createQuery("select geometrytype(p.geometry) from PolygonEntity as p where p is not null");
        i = 0;
        for (String gt : q.list()) {
            Assert.assertEquals((Object)"POLYGON", (Object)gt);
            ++i;
        }
        session.close();
    }

    public void testHQLEnvelope() throws Exception {
        org.hibernate.classic.Session session = this.factory.openSession();
        this.testHQLEnvelope("LineStringEntity", (Session)session);
        this.testHQLEnvelope("PolygonEntity", (Session)session);
        session.close();
    }

    private void testHQLEnvelope(String entityName, Session session) {
        Query q = session.createQuery("select envelope(e.geometry), e.geometry from " + entityName + " as e where e.geometry is not null");
        Iterator it = q.list().iterator();
        for (int i = 0; it.hasNext() && i < 10; ++i) {
            Object[] geoms = (Object[])it.next();
            Geometry env = (Geometry)geoms[0];
            env.normalize();
            Geometry g = (Geometry)geoms[1];
            Geometry env2 = g.getEnvelope();
            env2.normalize();
            Assert.assertTrue((boolean)env2.equalsExact(env, 0.01));
        }
    }

    public void testHQLIsEmpty(String sql) throws Exception {
        this.testHQL("isempty", sql, 1);
    }

    public void testHQLIsSimple(String sql) throws Exception {
        this.testHQL("issimple", sql, 1);
    }

    public void testHQLDistance() throws Exception {
        org.hibernate.classic.Session session = this.factory.openSession();
        Query q = session.createQuery("select distance(l.geometry, ?), l.geometry from LineStringEntity as l where l.geometry is not null");
        CustomType geometryType = new CustomType(GeometryUserType.class, null);
        q.setParameter(0, (Object)this.jtsFilter, (Type)geometryType);
        for (Object[] objs : q.list()) {
            Double distance = (Double)objs[0];
            Geometry geom = (Geometry)objs[1];
            Assert.assertEquals((double)geom.distance(this.jtsFilter), (double)distance, (double)0.003);
        }
        session.close();
    }

    public void testHQLDisjoint(String sqlTemplate) throws Exception {
        this.testHQL("disjoint", sqlTemplate, 2);
    }

    private void testHQLGeomOperation(String operation, Method jtsOper, Object[] args) throws Exception {
        for (int i = 0; i < entities.length; ++i) {
            if (entities[i].equalsIgnoreCase("MultiLineStringEntity")) continue;
            this.testHQLGeomOperation(operation, jtsOper, entities[i], args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHQLGeomOperation(String operation, Method jtsOper, String entity, Object[] args) throws Exception {
        org.hibernate.classic.Session session = null;
        try {
            session = this.factory.openSession();
            String opStr = operation + "( geometry";
            for (int i = 0; i < args.length; ++i) {
                opStr = opStr + ", ?";
            }
            opStr = opStr + ")";
            String queryStr = "select geometry, " + opStr + " from " + entity + " where geometry is not null";
            log.debug((Object)("HQL query str:" + queryStr));
            Query q = session.createQuery(queryStr);
            for (int idxp = 0; idxp < args.length; ++idxp) {
                if (args[idxp] instanceof Geometry) {
                    CustomType type = new CustomType(GeometryUserType.class, null);
                    q.setParameter(idxp, args[idxp], (Type)type);
                    continue;
                }
                q.setParameter(idxp, args[idxp]);
            }
            int cnt = 0;
            for (Object[] objs : q.list()) {
                Geometry geom = (Geometry)objs[0];
                Geometry opresult = (Geometry)objs[1];
                if (opresult != null) {
                    opresult.normalize();
                }
                Object[] jtsOperArgs = new Object[args.length];
                for (int idx = 0; idx < args.length; ++idx) {
                    jtsOperArgs[idx] = args[idx];
                }
                Geometry jtsOpResult = (Geometry)jtsOper.invoke((Object)geom, jtsOperArgs);
                jtsOpResult.normalize();
                if (this.approximateCoincident(opresult, jtsOpResult, 0.1)) continue;
                ++cnt;
                log.debug((Object)("Unequal results for " + operation + " on geom: " + geom + "\n\t db  result = " + opresult + "\n\t jts result = " + jtsOpResult));
                break;
            }
            Assert.assertTrue((String)(cnt + " unequal results for the operation"), (cnt == 0 ? 1 : 0) != 0);
            log.debug((Object)("Number of unequal results for operation " + operation + "  = " + cnt));
        }
        finally {
            try {
                session.close();
            }
            catch (Exception e) {}
        }
    }

    public void testHQLBoundary() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("getBoundary", new Class[0]);
        this.testHQLGeomOperation("boundary", jtsOper, new Object[0]);
    }

    public void testHQLBuffer() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("buffer", Double.TYPE);
        this.testHQLGeomOperation("buffer", jtsOper, new Object[]{new Double(100.0)});
    }

    public void testHQLConvexHull() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("convexHull", new Class[0]);
        this.testHQLGeomOperation("convexHull", jtsOper, new Object[0]);
    }

    public void testHQLDifference() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("difference", Geometry.class);
        this.testHQLGeomOperation("difference", jtsOper, new Object[]{this.jtsFilter});
    }

    public void testHQLIntersection() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("intersection", Geometry.class);
        this.testHQLGeomOperation("intersection", jtsOper, new Object[]{this.jtsFilter});
    }

    public void testHQLSymDifference() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("symDifference", Geometry.class);
        this.testHQLGeomOperation("symDifference", jtsOper, new Object[]{this.jtsFilter});
    }

    public void testHQLUnion() throws Exception {
        Method jtsOper = Geometry.class.getDeclaredMethod("union", Geometry.class);
        this.testHQLGeomOperation("geomunion", jtsOper, new Object[]{this.jtsFilter});
    }

    private boolean approximateCoincident(Geometry g1, Geometry g2, double tolerance) {
        Geometry e2;
        if (g1 == null && g2 != null || g2 == null && g1 != null) {
            return false;
        }
        if (g1 instanceof GeometryCollection && g2 instanceof GeometryCollection) {
            GeometryCollection gc1 = (GeometryCollection)g1;
            GeometryCollection gc2 = (GeometryCollection)g2;
            if (gc1.getNumGeometries() != gc2.getNumGeometries()) {
                return false;
            }
            for (int i = 0; i < gc1.getNumGeometries(); ++i) {
                boolean approx = this.approximateCoincident(gc1.getGeometryN(i), gc2.getGeometryN(i), tolerance);
                if (approx) continue;
                return approx;
            }
            return true;
        }
        Geometry e1 = g1.getEnvelope();
        boolean coincident = e1.equalsExact(e2 = g2.getEnvelope(), tolerance);
        if (!coincident) {
            return false;
        }
        boolean approxPointSetSize = false;
        if (g1.getDimension() == 0 && g2.getDimension() == 0) {
            return true;
        }
        approxPointSetSize = g1.getDimension() == 1 && g2.getDimension() == 1 ? Math.abs(g1.getLength() - g2.getLength()) / g1.getLength() < tolerance : Math.abs(g1.getArea() - g2.getArea()) / g1.getArea() < tolerance;
        return approxPointSetSize;
    }
}

