/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.cfg;

import java.io.File;
import org.hibernate.cfg.Configuration;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.cfg.HSConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class HSConfigurationTest {
    private static final String hibernate_config_location = "/Users/maesenka/workspaces/hibernate-spatial/hibernate-spatial-mysql/src/test/java/hibernate.cfg.xml";
    private static final String hs_config_location = "/Users/maesenka/workspaces/hibernate-spatial/hibernate-spatial/src/test/java/hibernate-spatial.cfg.xml";

    @Test
    public void testConfigure() {
        HSConfiguration config = new HSConfiguration();
        Configuration hibConfig = new Configuration();
        hibConfig.configure(new File(hibernate_config_location));
        config.configure(hibConfig);
        Assert.assertEquals((Object)"org.hibernatespatial.mysql.MySQLSpatialDialect", (Object)config.getDefaultDialect());
        config.configure();
        this.testResults(config);
    }

    @Test
    public void testConfigureFile() {
        HSConfiguration config = new HSConfiguration();
        config.configure(new File(hs_config_location));
        this.testResults(config);
    }

    @Test
    public void testConfigureFailure() {
        HSConfiguration config = new HSConfiguration();
        config.configure("non-existing-file");
    }

    @Test
    public void testHBSpatExtConfigure() {
        HSConfiguration config = new HSConfiguration();
        config.configure();
        HBSpatialExtension.setConfiguration((HSConfiguration)config);
    }

    private void testResults(HSConfiguration config) {
        Assert.assertEquals((Object)"org.hibernatespatial.postgis.PostgisDialect", (Object)config.getDefaultDialect());
        Assert.assertEquals((Object)"FIXED", (Object)config.getPrecisionModel());
        Assert.assertEquals((Object)"5", (Object)config.getPrecisionModelScale());
    }
}

