/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.PrecisionModel;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.hibernatespatial.mgeom.DoubleComparator;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MCoordinateSequenceFactory;
import org.hibernatespatial.mgeom.MGeometryException;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.mgeom.MLineString;

public class MLineStringTest
extends TestCase {
    private PrecisionModel prec = new PrecisionModel(PrecisionModel.FIXED);
    private MGeometryFactory mgeomFactory = new MGeometryFactory(MCoordinateSequenceFactory.instance());
    private MLineString controlledLine;
    private MLineString arbitraryLine;
    private MLineString nullLine;
    private MLineString ringLine;

    public static void main(String[] args) {
        TestRunner.run(MLineStringTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        MCoordinate mc0 = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
        MCoordinate mc1 = MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)0.0);
        MCoordinate mc2 = MCoordinate.create2dWithMeasure((double)1.0, (double)1.0, (double)0.0);
        MCoordinate mc3 = MCoordinate.create2dWithMeasure((double)2.0, (double)1.0, (double)0.0);
        MCoordinate[] mcoar = new MCoordinate[]{mc0, mc1, mc2, mc3};
        this.controlledLine = this.mgeomFactory.createMLineString(mcoar);
        mc0 = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
        mc1 = MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)0.0);
        mc2 = MCoordinate.create2dWithMeasure((double)1.0, (double)1.0, (double)0.0);
        mc3 = MCoordinate.create2dWithMeasure((double)0.0, (double)1.0, (double)0.0);
        MCoordinate mc4 = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
        mcoar = new MCoordinate[]{mc0, mc1, mc2, mc3, mc4};
        this.ringLine = this.mgeomFactory.createMLineString(mcoar);
        int l = (int)Math.round(Math.random() * 250.0);
        l = Math.max(2, l);
        System.out.println("Size of arbitraryline ==" + l);
        mcoar = new MCoordinate[l];
        for (int i = 0; i < mcoar.length; ++i) {
            double x = Math.random() * 100000.0;
            double y = Math.random() * 100000.0;
            double z = Double.NaN;
            double m = Math.random() * 100000.0;
            mcoar[i] = new MCoordinate(x, y, z, m);
        }
        this.arbitraryLine = this.mgeomFactory.createMLineString(mcoar);
        mcoar = new MCoordinate[]{};
        this.nullLine = this.mgeomFactory.createMLineString(mcoar);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public MLineStringTest(String name) {
        super(name);
    }

    public void testClone() {
        MLineString mltest = (MLineString)this.arbitraryLine.clone();
        Coordinate[] testco = mltest.getCoordinates();
        Coordinate[] arco = this.arbitraryLine.getCoordinates();
        MLineStringTest.assertEquals((int)testco.length, (int)arco.length);
        for (int i = 0; i < arco.length; ++i) {
            MLineStringTest.assertEquals((Object)arco[i], (Object)testco[i]);
            MLineStringTest.assertNotSame((Object)arco[i], (Object)testco[i]);
        }
        mltest = (MLineString)this.nullLine.clone();
        MLineStringTest.assertEquals((boolean)mltest.isEmpty(), (boolean)this.nullLine.isEmpty());
        MLineStringTest.assertTrue((boolean)mltest.isEmpty());
    }

    public void testGetClosestPoint() {
        MCoordinate mc;
        try {
            if (!this.arbitraryLine.isMonotone(false)) {
                mc = this.arbitraryLine.getClosestPoint(new Coordinate(1.0, 2.0), 0.1);
                MLineStringTest.assertTrue((boolean)false);
            }
        }
        catch (Exception e) {
            MLineStringTest.assertTrue((((MGeometryException)e).getType() == 1 ? 1 : 0) != 0);
        }
        try {
            mc = this.nullLine.getClosestPoint(new Coordinate(0.0, 1.0), 1.0);
            MLineStringTest.assertNull((Object)mc);
            this.arbitraryLine.measureOnLength(false);
            int selp = this.arbitraryLine.getNumPoints() / 2;
            MCoordinate mcexp = (MCoordinate)this.arbitraryLine.getCoordinateN(selp);
            MCoordinate mctest = this.arbitraryLine.getClosestPoint((Coordinate)mcexp, 1.0);
            MLineStringTest.assertEquals((Object)mcexp, (Object)mctest);
            mctest = this.controlledLine.getClosestPoint(new Coordinate(20.0, 20.0, 0.0), 1.0);
            MLineStringTest.assertNull((Object)mctest);
            this.ringLine.measureOnLength(false);
            MLineStringTest.assertTrue((boolean)this.ringLine.isRing());
            MLineStringTest.assertTrue((boolean)this.ringLine.isMonotone(false));
            MLineStringTest.assertTrue((this.ringLine.getMeasureDirection() == 1 ? 1 : 0) != 0);
            MCoordinate expCo = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
            MCoordinate testCo = this.ringLine.getClosestPoint((Coordinate)expCo, 0.1);
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)testCo.m, (double)expCo.m));
            this.ringLine.reverseMeasures();
            testCo = this.ringLine.getClosestPoint((Coordinate)expCo, 0.1);
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)testCo.m, (double)expCo.m));
            this.ringLine.measureOnLength(false);
            int n = this.ringLine.getNumPoints() - 1;
            this.ringLine.setMeasureAtIndex(n, 100.0);
            this.ringLine.setMeasureAtIndex(0, 0.0);
            testCo = this.ringLine.getClosestPoint((Coordinate)expCo, 0.001);
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)testCo.m, (double)0.0));
            this.arbitraryLine.measureOnLength(false);
            int elem1Indx = (int)(Math.random() * (double)(this.arbitraryLine.getNumPoints() - 1));
            int elem2Indx = 0;
            elem2Indx = elem1Indx == this.arbitraryLine.getNumPoints() - 1 ? elem1Indx - 1 : elem1Indx + 1;
            MCoordinate mco1 = (MCoordinate)this.arbitraryLine.getCoordinateN(elem1Indx);
            MCoordinate mco2 = (MCoordinate)this.arbitraryLine.getCoordinateN(elem2Indx);
            double d = mco1.distance((Coordinate)mco2);
            double offset = Math.random();
            mcexp = MCoordinate.create2dWithMeasure((double)(mco1.x + offset * (mco2.x - mco1.x)), (double)(mco1.y + offset * (mco2.y - mco1.y)), (double)0.0);
            mctest = this.arbitraryLine.getClosestPoint((Coordinate)mcexp, d);
            mcexp.m = mco1.m + offset * (mco2.m - mco1.m);
            MLineStringTest.assertEquals((double)mcexp.x, (double)mctest.x, (double)1.0E-17);
            MLineStringTest.assertEquals((double)mcexp.y, (double)mctest.y, (double)1.0E-17);
            MLineStringTest.assertEquals((double)mcexp.z, (double)mctest.z, (double)1.0E-17);
            double delta = Math.random();
            MCoordinate mcin = MCoordinate.create2dWithMeasure((double)(mco1.x + offset * (mco2.x - mco1.x) + delta), (double)(mco1.y + offset * (mco2.y - mco1.y) + delta), (double)0.0);
            mctest = this.arbitraryLine.getClosestPoint((Coordinate)mcin, d);
            MLineStringTest.assertEquals((double)mcin.x, (double)mctest.x, (double)(delta * Math.sqrt(2.0)));
            MLineStringTest.assertEquals((double)mcin.y, (double)mctest.y, (double)(delta * Math.sqrt(2.0)));
        }
        catch (Exception e) {
            e.printStackTrace();
            MLineStringTest.assertTrue((boolean)false);
        }
    }

    public void testGetCoordinateAtM() {
        try {
            Coordinate mc = this.nullLine.getCoordinateAtM(2.0);
            MLineStringTest.assertNull((Object)mc);
            this.arbitraryLine.measureOnLength(false);
            int elem1Indx = (int)(Math.random() * (double)(this.arbitraryLine.getNumPoints() - 1));
            int elem2Indx = 0;
            elem2Indx = elem1Indx == this.arbitraryLine.getNumPoints() - 1 ? elem1Indx - 1 : elem1Indx + 1;
            MCoordinate mco1 = (MCoordinate)this.arbitraryLine.getCoordinateN(elem1Indx);
            MCoordinate mcotest = (MCoordinate)this.arbitraryLine.getCoordinateAtM(mco1.m);
            MLineStringTest.assertNotSame((Object)mco1, (Object)mcotest);
            MLineStringTest.assertEquals((Object)mco1, (Object)mcotest);
            MCoordinate mco2 = (MCoordinate)this.arbitraryLine.getCoordinateN(elem2Indx);
            double offset = Math.random();
            double newM = mco1.m + offset * (mco2.m - mco1.m);
            MCoordinate mcexp = new MCoordinate(mco1.x + offset * (mco2.x - mco1.x), mco1.y + offset * (mco2.y - mco1.y), Double.NaN, mco1.m + offset * (mco2.m - mco1.m));
            MCoordinate mctest = (MCoordinate)this.arbitraryLine.getCoordinateAtM(newM);
            MLineStringTest.assertEquals((Object)mcexp, (Object)mctest);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void testGetGeometryType() {
        MLineStringTest.assertEquals((String)"MLineString", (String)this.arbitraryLine.getGeometryType());
    }

    public void testGetMatCoordinate() {
        try {
            MLineStringTest.assertTrue((boolean)Double.isNaN(this.nullLine.getMatCoordinate(new Coordinate(1.0, 1.0), 1.0)));
            this.arbitraryLine.measureOnLength(false);
            int elem1Indx = (int)(Math.random() * (double)(this.arbitraryLine.getNumPoints() - 1));
            int elem2Indx = 0;
            elem2Indx = elem1Indx == this.arbitraryLine.getNumPoints() - 1 ? elem1Indx - 1 : elem1Indx + 1;
            MCoordinate mco1 = (MCoordinate)this.arbitraryLine.getCoordinateN(elem1Indx);
            double m = this.arbitraryLine.getMatCoordinate((Coordinate)mco1, 1.0E-5);
            MLineStringTest.assertEquals((double)mco1.m, (double)m, (double)DoubleComparator.defaultNumericalPrecision());
            MCoordinate mco2 = (MCoordinate)this.arbitraryLine.getCoordinateN(elem2Indx);
            double offset = Math.random();
            double expectedM = mco1.m + offset * (mco2.m - mco1.m);
            Coordinate mctest = new Coordinate(mco1.x + offset * (mco2.x - mco1.x), mco1.y + offset * (mco2.y - mco1.y));
            double testM = this.arbitraryLine.getMatCoordinate(mctest, offset);
            MLineStringTest.assertEquals((double)expectedM, (double)testM, (double)DoubleComparator.defaultNumericalPrecision());
        }
        catch (Exception e) {
            e.printStackTrace();
            MLineStringTest.assertTrue((boolean)false);
        }
    }

    public void testGetMatN() {
    }

    public void testGetMaxM() {
    }

    public void testGetCoordinatesBetween() {
        try {
            int i;
            CoordinateSequence[] cs = this.nullLine.getCoordinatesBetween(0.0, 5.0);
            MLineStringTest.assertTrue((cs.length == 0 ? 1 : 0) != 0);
            this.arbitraryLine.measureOnLength(false);
            double maxM = this.arbitraryLine.getMaxM();
            cs = this.arbitraryLine.getCoordinatesBetween(maxM + 1.0, maxM + 10.0);
            int minIdx = (int)(Math.random() * (double)(this.arbitraryLine.getNumPoints() - 1));
            int maxIdx = Math.min(this.arbitraryLine.getNumPoints() - 1, minIdx + 10);
            double minM = ((MCoordinate)this.arbitraryLine.getCoordinateN((int)minIdx)).m;
            maxM = ((MCoordinate)this.arbitraryLine.getCoordinateN((int)maxIdx)).m;
            cs = this.arbitraryLine.getCoordinatesBetween(minM, maxM);
            MLineStringTest.assertNotNull((Object)cs);
            MLineStringTest.assertTrue((cs.length > 0 ? 1 : 0) != 0);
            Coordinate[] coar = cs[0].toCoordinateArray();
            int j = 0;
            for (i = minIdx; i <= maxIdx; ++i) {
                MLineStringTest.assertEquals((Object)((MCoordinate)this.arbitraryLine.getCoordinateN(i)), (Object)coar[j]);
                ++j;
            }
            cs = this.arbitraryLine.getCoordinatesBetween(maxM, minM);
            MLineStringTest.assertNotNull((Object)cs);
            MLineStringTest.assertTrue((cs.length > 0 ? 1 : 0) != 0);
            coar = cs[0].toCoordinateArray();
            j = 0;
            for (i = maxIdx; i >= minIdx; --i) {
                MLineStringTest.assertEquals((Object)((MCoordinate)this.arbitraryLine.getCoordinateN(i)), (Object)coar[j]);
                ++j;
            }
            minM = Math.max(0.0, minM - Math.random() * 10.0);
            cs = this.arbitraryLine.getCoordinatesBetween(minM, maxM);
            coar = cs[0].toCoordinateArray();
            MCoordinate mctest = (MCoordinate)coar[0];
            MCoordinate mcexp = (MCoordinate)this.arbitraryLine.getCoordinateAtM(minM);
            MLineStringTest.assertEquals((Object)mcexp, (Object)mctest);
            MLineStringTest.assertEquals((double)mctest.m, (double)minM, (double)DoubleComparator.defaultNumericalPrecision());
            maxM = Math.min(this.arbitraryLine.getLength(), maxM + Math.random() * 10.0);
            cs = this.arbitraryLine.getCoordinatesBetween(minM, maxM);
            coar = cs[0].toCoordinateArray();
            mctest = (MCoordinate)coar[coar.length - 1];
            mcexp = (MCoordinate)this.arbitraryLine.getCoordinateAtM(maxM);
            MLineStringTest.assertEquals((Object)mcexp, (Object)mctest);
            MLineStringTest.assertEquals((double)mctest.m, (double)maxM, (double)DoubleComparator.defaultNumericalPrecision());
        }
        catch (Exception e) {
            e.printStackTrace();
            MLineStringTest.assertTrue((boolean)false);
        }
    }

    public void testGetMeasureDirection() {
        MLineStringTest.assertTrue((boolean)this.nullLine.isMonotone(false));
        MLineStringTest.assertTrue((this.arbitraryLine.isMonotone(false) || !this.arbitraryLine.isMonotone(false) && this.arbitraryLine.getMeasureDirection() == -3 ? 1 : 0) != 0);
        this.arbitraryLine.measureOnLength(false);
        MLineStringTest.assertEquals((int)1, (int)this.arbitraryLine.getMeasureDirection());
        this.arbitraryLine.reverseMeasures();
        MLineStringTest.assertEquals((int)-1, (int)this.arbitraryLine.getMeasureDirection());
        for (int i = 0; i < this.arbitraryLine.getNumPoints(); ++i) {
            this.arbitraryLine.setMeasureAtIndex(i, 0.0);
        }
        MLineStringTest.assertEquals((int)0, (int)this.arbitraryLine.getMeasureDirection());
    }

    public void testGetMeasures() {
    }

    public void testGetMinM() {
    }

    public void testInterpolate() {
        MCoordinate mc0NaN = MCoordinate.create2d((double)0.0, (double)0.0);
        MCoordinate mc0 = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
        MCoordinate mc2NaN = MCoordinate.create2d((double)2.0, (double)0.0);
        MCoordinate mc5NaN = MCoordinate.create2d((double)5.0, (double)0.0);
        MCoordinate mc10NaN = MCoordinate.create2d((double)10.0, (double)0.0);
        MCoordinate mc10 = MCoordinate.create2dWithMeasure((double)10.0, (double)0.0, (double)10.0);
        MLineString line = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc2NaN, mc5NaN, mc10});
        MLineString lineBeginNaN = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0NaN, mc2NaN, mc5NaN, mc10});
        MLineString lineEndNaN = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc2NaN, mc5NaN, mc10NaN});
        MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)line.getLength(), (double)10.0));
        MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)lineBeginNaN.getLength(), (double)10.0));
        MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)lineEndNaN.getLength(), (double)10.0));
        line.interpolate(mc0.m, mc10.m);
        lineBeginNaN.interpolate(mc0.m, mc10.m);
        lineEndNaN.interpolate(mc0.m, mc10.m);
        MLineStringTest.assertTrue((boolean)line.isMonotone(false));
        MLineStringTest.assertTrue((boolean)line.isMonotone(true));
        MLineStringTest.assertTrue((boolean)lineBeginNaN.isMonotone(false));
        MLineStringTest.assertTrue((boolean)lineBeginNaN.isMonotone(true));
        MLineStringTest.assertTrue((boolean)lineEndNaN.isMonotone(false));
        MLineStringTest.assertTrue((boolean)lineEndNaN.isMonotone(true));
        double[] expectedM = new double[]{mc0.m, 2.0, 5.0, mc10.m};
        for (int i = 0; i < expectedM.length; ++i) {
            double actualMLine = line.getCoordinateSequence().getOrdinate(i, 3);
            double actualBeginNaN = lineBeginNaN.getCoordinateSequence().getOrdinate(i, 3);
            double actualEndNaN = lineEndNaN.getCoordinateSequence().getOrdinate(i, 3);
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)expectedM[i], (double)actualMLine));
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)expectedM[i], (double)actualBeginNaN));
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)expectedM[i], (double)actualEndNaN));
        }
        double continuousMeasure = 0.0;
        line.interpolate(continuousMeasure, continuousMeasure);
        double[] measures = line.getMeasures();
        for (int i = 0; i < measures.length; ++i) {
            MLineStringTest.assertTrue((boolean)DoubleComparator.equals((double)measures[i], (double)continuousMeasure));
        }
    }

    public void testIsMonotone() {
        MCoordinate mc0NaN = MCoordinate.create2d((double)1.0, (double)0.0);
        MCoordinate mc0 = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
        MCoordinate mc1NaN = MCoordinate.create2d((double)1.0, (double)0.0);
        MCoordinate mc1 = MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0);
        MCoordinate mc2NaN = MCoordinate.create2d((double)2.0, (double)0.0);
        MCoordinate mc2 = MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0);
        MCoordinate mc3NaN = MCoordinate.create2d((double)3.0, (double)0.0);
        MCoordinate mc3 = MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0);
        MLineString emptyLine = this.mgeomFactory.createMLineString(new MCoordinate[0]);
        MLineString orderedLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc1, mc2, mc3});
        MLineString unorderedLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc2, mc1, mc3});
        MLineString constantLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc2, mc2, mc2, mc2});
        MLineString reverseOrderedLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc3, mc2, mc1, mc0});
        MLineString reverseUnOrderedLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc3, mc1, mc2, mc0});
        MLineString dupCoordLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc1, mc1, mc2});
        MLineString reverseDupCoordLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc2, mc1, mc1, mc0});
        MLineStringTest.assertTrue((boolean)emptyLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)emptyLine.isMonotone(true));
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(true));
        orderedLine.reverseMeasures();
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(true));
        orderedLine.shiftMeasure(1.0);
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(true));
        orderedLine.shiftMeasure(-1.0);
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)orderedLine.isMonotone(true));
        MLineStringTest.assertFalse((boolean)unorderedLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)unorderedLine.isMonotone(true));
        MLineStringTest.assertTrue((boolean)constantLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)constantLine.isMonotone(true));
        constantLine.shiftMeasure(1.0);
        MLineStringTest.assertTrue((boolean)constantLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)constantLine.isMonotone(true));
        constantLine.shiftMeasure(-1.0);
        MLineStringTest.assertTrue((boolean)constantLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)constantLine.isMonotone(true));
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(true));
        reverseOrderedLine.reverseMeasures();
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(true));
        reverseOrderedLine.shiftMeasure(1.0);
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(true));
        reverseOrderedLine.shiftMeasure(-1.0);
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)reverseOrderedLine.isMonotone(true));
        MLineStringTest.assertFalse((boolean)reverseUnOrderedLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)reverseUnOrderedLine.isMonotone(true));
        MLineStringTest.assertTrue((boolean)dupCoordLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)dupCoordLine.isMonotone(true));
        dupCoordLine.shiftMeasure(1.0);
        MLineStringTest.assertTrue((boolean)dupCoordLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)dupCoordLine.isMonotone(true));
        dupCoordLine.shiftMeasure(-1.0);
        MLineStringTest.assertTrue((boolean)dupCoordLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)dupCoordLine.isMonotone(true));
        MLineStringTest.assertTrue((boolean)reverseDupCoordLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)reverseDupCoordLine.isMonotone(true));
        reverseDupCoordLine.shiftMeasure(1.0);
        MLineStringTest.assertTrue((boolean)reverseDupCoordLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)reverseDupCoordLine.isMonotone(true));
        reverseDupCoordLine.shiftMeasure(-1.0);
        MLineStringTest.assertTrue((boolean)reverseDupCoordLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)reverseDupCoordLine.isMonotone(true));
        MLineStringTest.assertEquals((int)orderedLine.getMeasureDirection(), (int)1);
        MLineStringTest.assertEquals((int)unorderedLine.getMeasureDirection(), (int)-3);
        MLineStringTest.assertEquals((int)reverseOrderedLine.getMeasureDirection(), (int)-1);
        MLineStringTest.assertEquals((int)dupCoordLine.getMeasureDirection(), (int)1);
        MLineStringTest.assertEquals((int)reverseDupCoordLine.getMeasureDirection(), (int)-1);
        MLineString internalNaNLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc1NaN, mc2NaN, mc3});
        MLineString beginNaNLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0NaN, mc2, mc3});
        MLineString endNaNLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc2, mc3NaN});
        MLineString beginEndNaNLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0NaN, mc2, mc3NaN});
        MLineStringTest.assertFalse((boolean)internalNaNLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)internalNaNLine.isMonotone(true));
        internalNaNLine.measureOnLength(false);
        MLineStringTest.assertTrue((boolean)internalNaNLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)internalNaNLine.isMonotone(true));
        MLineStringTest.assertFalse((boolean)beginNaNLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)beginNaNLine.isMonotone(true));
        beginNaNLine.measureOnLength(false);
        MLineStringTest.assertTrue((boolean)beginNaNLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)beginNaNLine.isMonotone(true));
        MLineStringTest.assertFalse((boolean)endNaNLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)endNaNLine.isMonotone(true));
        endNaNLine.measureOnLength(false);
        MLineStringTest.assertTrue((boolean)endNaNLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)endNaNLine.isMonotone(true));
        MLineStringTest.assertFalse((boolean)beginEndNaNLine.isMonotone(false));
        MLineStringTest.assertFalse((boolean)beginEndNaNLine.isMonotone(true));
        beginEndNaNLine.measureOnLength(false);
        MLineStringTest.assertTrue((boolean)beginEndNaNLine.isMonotone(false));
        MLineStringTest.assertTrue((boolean)beginEndNaNLine.isMonotone(true));
    }

    public void testGetCoordinatesBetweenNonStrict() {
        try {
            CoordinateSequenceComparator coordCompare = new CoordinateSequenceComparator();
            MCoordinate mc0 = MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0);
            MCoordinate mc1 = MCoordinate.create2dWithMeasure((double)0.0, (double)1.0, (double)1.0);
            MCoordinate mc2_1 = MCoordinate.create2dWithMeasure((double)0.0, (double)2.0, (double)1.0);
            MCoordinate mc2 = MCoordinate.create2dWithMeasure((double)0.0, (double)2.0, (double)2.0);
            MCoordinate mc3 = MCoordinate.create2dWithMeasure((double)0.0, (double)3.0, (double)3.0);
            MCoordinate mc4 = MCoordinate.create2dWithMeasure((double)0.0, (double)4.0, (double)4.0);
            MLineString nonStrictDupPointLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc1, mc1, mc2, mc3});
            MLineString strictLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc1, mc2, mc3});
            CoordinateSequence[] nonStrictDupSeq = nonStrictDupPointLine.getCoordinatesBetween(mc0.m, mc2_1.m);
            CoordinateSequence[] strictSeq = strictLine.getCoordinatesBetween(mc0.m, mc1.m);
            MLineStringTest.assertEquals((int)nonStrictDupSeq.length, (int)1);
            MLineStringTest.assertEquals((int)strictSeq.length, (int)1);
            MLineStringTest.assertTrue((coordCompare.compare((Object)nonStrictDupSeq[0], (Object)strictSeq[0]) == 0 ? 1 : 0) != 0);
            MLineStringTest.assertEquals((int)strictSeq[0].size(), (int)2);
            MLineString nonStrictPointLine = this.mgeomFactory.createMLineString(new MCoordinate[]{mc0, mc1, mc2_1, mc3, mc4});
            CoordinateSequence[] nonStrictSeq = nonStrictPointLine.getCoordinatesBetween(mc0.m, mc2_1.m);
            MLineStringTest.assertNotNull((Object)nonStrictSeq);
            nonStrictSeq = nonStrictPointLine.getCoordinatesBetween(mc0.m, mc4.m);
            MLineStringTest.assertNotNull((Object)nonStrictSeq);
            nonStrictSeq = nonStrictPointLine.getCoordinatesBetween(mc1.m, mc4.m);
            MLineStringTest.assertNotNull((Object)nonStrictSeq);
            nonStrictSeq = nonStrictPointLine.getCoordinatesBetween(1.1, mc4.m);
            MLineStringTest.assertNotNull((Object)nonStrictSeq);
        }
        catch (MGeometryException e) {
            e.printStackTrace();
        }
    }

    public void testmeasureOnLength() {
        this.arbitraryLine.measureOnLength(false);
        double maxM = this.arbitraryLine.getMaxM();
        double minM = this.arbitraryLine.getMinM();
        MLineStringTest.assertEquals((double)maxM, (double)this.arbitraryLine.getLength(), (double)DoubleComparator.defaultNumericalPrecision());
        MLineStringTest.assertEquals((double)minM, (double)0.0, (double)DoubleComparator.defaultNumericalPrecision());
        MCoordinate mco = (MCoordinate)this.arbitraryLine.getCoordinateN(this.arbitraryLine.getNumPoints() - 1);
        MLineStringTest.assertEquals((double)mco.m, (double)maxM, (double)DoubleComparator.defaultNumericalPrecision());
        mco = (MCoordinate)this.arbitraryLine.getCoordinateN(0);
        MLineStringTest.assertEquals((double)mco.m, (double)minM, (double)DoubleComparator.defaultNumericalPrecision());
    }

    public void testReverseMeasures() {
        this.nullLine.reverseMeasures();
        this.arbitraryLine.measureOnLength(false);
        this.arbitraryLine.reverseMeasures();
        MLineStringTest.assertTrue((this.arbitraryLine.getMeasureDirection() == -1 ? 1 : 0) != 0);
        double mlast = this.arbitraryLine.getMatN(this.arbitraryLine.getNumPoints() - 1);
        this.arbitraryLine.reverseMeasures();
        MLineStringTest.assertTrue((this.arbitraryLine.getMeasureDirection() == 1 ? 1 : 0) != 0);
        double mfirst = this.arbitraryLine.getMatN(0);
        MLineStringTest.assertEquals((double)mlast, (double)mfirst, (double)DoubleComparator.defaultNumericalPrecision());
    }

    public void testSetMatN() {
    }

    public void testShiftMBy() {
    }

    public void testToString() {
    }

    public void testUnionM() {
    }

    public void testVerifyMonotone() {
    }
}

