/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.lang.reflect.Constructor;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.mgeom.MLineString;
import org.hibernatespatial.mgeom.MultiMLineString;
import org.hibernatespatial.test.model.LineStringEntity;
import org.hibernatespatial.test.model.MLineStringEntity;
import org.hibernatespatial.test.model.MultiLineStringEntity;
import org.hibernatespatial.test.model.MultiMLineStringEntity;
import org.hibernatespatial.test.model.MultiPointEntity;
import org.hibernatespatial.test.model.MultiPolygonEntity;
import org.hibernatespatial.test.model.PointEntity;
import org.hibernatespatial.test.model.PolygonEntity;

public class DataGenerator {
    private static final int SIZE = 1000;
    private static final double minCoordValue = 0.0;
    private static final double maxCoordValue = 100000.0;
    private static final int maxNumGeom = 10;
    private static final int maxNumCoords = 20;
    private static final MGeometryFactory geomFactory = new MGeometryFactory(new PrecisionModel(), 31370);

    public void generate() {
        Configuration config = new Configuration();
        config.configure();
        config.addClass(LineStringEntity.class);
        config.addClass(MultiLineStringEntity.class);
        config.addClass(PolygonEntity.class);
        config.addClass(PointEntity.class);
        config.addClass(MultiPointEntity.class);
        config.addClass(MultiPolygonEntity.class);
        config.addClass(MLineStringEntity.class);
        config.addClass(MultiMLineStringEntity.class);
        Settings settings = config.buildSettings();
        System.out.println("Generating Data for Dialect: " + settings.getDialect().getClass().getName());
        SessionFactory factory = config.buildSessionFactory();
        DataGenerator.generateData(LineStringEntity.class, factory, new LineStringCreator());
        DataGenerator.generateData(MultiLineStringEntity.class, factory, new MultiLineStringCreator());
        DataGenerator.generateData(PolygonEntity.class, factory, new PolygonCreator());
        DataGenerator.generateData(PointEntity.class, factory, new PointCreator());
        DataGenerator.generateData(MLineStringEntity.class, factory, new MLineStringCreator());
        DataGenerator.generateData(MultiMLineStringEntity.class, factory, new MultiMLineStringCreator());
        factory.close();
    }

    private static void generateData(Class entityClass, SessionFactory factory, GeomCreator creator) {
        Session session = factory.openSession();
        Transaction tx = null;
        try {
            System.out.println("Writing " + entityClass.getSimpleName());
            for (int i = 0; i < 1000; ++i) {
                tx = session.beginTransaction();
                Object geom = creator.create();
                Constructor constructor = entityClass.getConstructor(Long.TYPE, String.class, Geometry.class);
                Object entity = constructor.newInstance(i, "feature " + i, geom);
                session.save(entity);
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException("Failed loading data of type " + entityClass.getSimpleName(), e);
        }
        finally {
            session.close();
            session = null;
        }
    }

    private static double getRandomCoordinateValue() {
        return 100000.0 * Math.random();
    }

    private static int getRandomNumGeoms() {
        double dn = 1.0 + 9.0 * Math.random();
        int num = Math.round((float)dn);
        return num;
    }

    private static int getRandomNumCoords(int minValue) {
        double dn = (double)minValue + (double)(20 - minValue) * Math.random();
        int num = Math.round((float)dn);
        return num;
    }

    private static Coordinate getRandomCoordinate() {
        double x = DataGenerator.getRandomCoordinateValue();
        double y = DataGenerator.getRandomCoordinateValue();
        return new Coordinate(x, y);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointCreator
    implements GeomCreator<Point> {
        public static final double numPoints = 1000.0;

        private PointCreator() {
        }

        @Override
        public Point create() {
            Coordinate c = DataGenerator.getRandomCoordinate();
            return geomFactory.createPoint(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PolygonCreator
    implements GeomCreator<Polygon> {
        private PolygonCreator() {
        }

        @Override
        public Polygon create() {
            LinearRing lr = new LinearRingCreator().create();
            Polygon pg = geomFactory.createPolygon(lr, null);
            return pg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinearRingCreator
    implements GeomCreator<LinearRing> {
        private LinearRingCreator() {
        }

        @Override
        public LinearRing create() {
            int numCoords = 4;
            Coordinate[] coordinates = new Coordinate[numCoords + 1];
            coordinates[0] = DataGenerator.getRandomCoordinate();
            coordinates[1] = new Coordinate(coordinates[0].x, coordinates[0].y + 10.0);
            coordinates[2] = new Coordinate(coordinates[0].x + 10.0, coordinates[0].y + 10.0);
            coordinates[3] = new Coordinate(coordinates[0].x + 10.0, coordinates[0].y);
            coordinates[numCoords] = coordinates[0];
            LinearRing lr = geomFactory.createLinearRing(coordinates);
            return lr;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiMLineStringCreator
    implements GeomCreator<MultiMLineString> {
        private MultiMLineStringCreator() {
        }

        @Override
        public MultiMLineString create() {
            int numGeoms = 1 + DataGenerator.getRandomNumGeoms();
            MLineStringCreator mlsc = new MLineStringCreator();
            MLineString[] mlines = new MLineString[numGeoms];
            for (int i = 0; i < numGeoms; ++i) {
                mlines[i] = mlsc.create();
            }
            return geomFactory.createMultiMLineString(mlines);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiLineStringCreator
    implements GeomCreator<MultiLineString> {
        private MultiLineStringCreator() {
        }

        @Override
        public MultiLineString create() {
            int numGeoms = 1 + DataGenerator.getRandomNumGeoms();
            LineStringCreator lsc = new LineStringCreator();
            LineString[] lines = new LineString[numGeoms];
            for (int i = 0; i < numGeoms; ++i) {
                lines[i] = lsc.create();
            }
            return geomFactory.createMultiLineString(lines);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MLineStringCreator
    implements GeomCreator<MLineString> {
        private MLineStringCreator() {
        }

        @Override
        public MLineString create() {
            int numCoords = DataGenerator.getRandomNumCoords(2);
            MCoordinate[] coordinates = new MCoordinate[numCoords];
            double mValue = 0.0;
            for (int i = 0; i < numCoords; ++i) {
                Coordinate rc = DataGenerator.getRandomCoordinate();
                MCoordinate mrc = new MCoordinate(rc);
                if (i > 0) {
                    mValue += coordinates[i - 1].distance(rc);
                }
                mrc.m = mValue;
                coordinates[i] = mrc;
            }
            return geomFactory.createMLineString(coordinates);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LineStringCreator
    implements GeomCreator<LineString> {
        private LineStringCreator() {
        }

        @Override
        public LineString create() {
            int numCoords = DataGenerator.getRandomNumCoords(2);
            Coordinate[] coordinates = new Coordinate[numCoords];
            for (int i = 0; i < numCoords; ++i) {
                coordinates[i] = DataGenerator.getRandomCoordinate();
            }
            return geomFactory.createLineString(coordinates);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GeomCreator<T extends Geometry> {
        public T create();
    }
}

