/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.pojo.reader;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.dom4j.Document;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.cfg.HSConfiguration;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.pojo.POJOUtility;
import org.hibernatespatial.pojo.TypeMapper;
import org.hibernatespatial.pojo.reader.BasicFeatureReader;
import org.hibernatespatial.pojo.reader.Feature;
import org.junit.Assert;

public class TestBasicFeatureReader {
    private SessionFactory sessionFactory;
    private POJOUtility pojoUtil;

    public void setUpBeforeClass(HSConfiguration hsconfig, Connection conn) throws SQLException {
        Document mappingdocument;
        HBSpatialExtension.setConfiguration((HSConfiguration)hsconfig);
        SpatialDialect dialect = HBSpatialExtension.getDefaultSpatialDialect();
        TypeMapper typeMapper = new TypeMapper(dialect.getDbGeometryTypeName());
        this.pojoUtil = new POJOUtility(conn, "test.model", typeMapper);
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("linestringtest");
        tables.add("multilinestringtest");
        tables.add("polygontest");
        try {
            mappingdocument = this.pojoUtil.map(tables);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Configuration config = new Configuration();
        config.addXML(mappingdocument.asXML());
        this.sessionFactory = config.configure().buildSessionFactory();
    }

    public void testReaderNoFilters(int expected) throws FinderException {
        Class clazz = this.pojoUtil.getClassInfoMap().getClassInfo("linestringtest").getPOJOClass();
        BasicFeatureReader reader = new BasicFeatureReader(clazz, this.sessionFactory, null, null);
        int count = 0;
        while (reader.hasNext()) {
            Feature f = reader.next();
            Assert.assertNotNull((Object)f.getId());
            ++count;
        }
        Assert.assertEquals((Object)expected, (Object)count);
        reader.close();
    }
}

