/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.helper;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.property.Getter;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernatespatial.helper.FinderException;
import org.hibernatespatial.helper.FinderStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSClassMetadata
implements ClassMetadata {
    private final ClassMetadata metadata;
    private FinderStrategy<String, ClassMetadata> geomPropertyFinder = new FindGeomProperty();

    public HSClassMetadata(ClassMetadata metadata) {
        this.metadata = metadata;
    }

    public void setGeomPropertyFinder(FinderStrategy<String, ClassMetadata> finder) {
        this.geomPropertyFinder = finder;
    }

    public String getGeometryPropertyName() throws FinderException {
        return this.geomPropertyFinder.find(this.metadata);
    }

    public Method getGeomGetter() {
        try {
            String prop = this.getGeometryPropertyName();
            return this.getGetterFor(prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Method getIdGetter() {
        String prop = this.getIdentifierPropertyName();
        return this.getGetterFor(prop);
    }

    public Method getGetterFor(String property) {
        Class cl = this.metadata.getMappedClass(EntityMode.POJO);
        Getter getter = ReflectHelper.getGetter((Class)cl, (String)property);
        return getter.getMethod();
    }

    public String getEntityName() {
        return this.metadata.getEntityName();
    }

    public Serializable getIdentifier(Object entity, EntityMode entityMode) throws HibernateException {
        return this.metadata.getIdentifier(entity, entityMode);
    }

    public String getIdentifierPropertyName() {
        return this.metadata.getIdentifierPropertyName();
    }

    public Type getIdentifierType() {
        return this.metadata.getIdentifierType();
    }

    public Class getMappedClass(EntityMode entityMode) {
        return this.metadata.getMappedClass(entityMode);
    }

    public int[] getNaturalIdentifierProperties() {
        return this.metadata.getNaturalIdentifierProperties();
    }

    public boolean[] getPropertyLaziness() {
        return this.metadata.getPropertyLaziness();
    }

    public String[] getPropertyNames() {
        return this.metadata.getPropertyNames();
    }

    public boolean[] getPropertyNullability() {
        return this.metadata.getPropertyNullability();
    }

    public Type getPropertyType(String propertyName) throws HibernateException {
        return this.metadata.getPropertyType(propertyName);
    }

    public Type[] getPropertyTypes() {
        return this.metadata.getPropertyTypes();
    }

    public Object getPropertyValue(Object object, String propertyName, EntityMode entityMode) throws HibernateException {
        return this.metadata.getPropertyValue(object, propertyName, entityMode);
    }

    public Object[] getPropertyValues(Object entity, EntityMode entityMode) throws HibernateException {
        return this.metadata.getPropertyValues(entity, entityMode);
    }

    public Object[] getPropertyValuesToInsert(Object entity, Map mergeMap, SessionImplementor session) throws HibernateException {
        return this.metadata.getPropertyValuesToInsert(entity, mergeMap, session);
    }

    public Object getVersion(Object object, EntityMode entityMode) throws HibernateException {
        return this.metadata.getVersion(object, entityMode);
    }

    public int getVersionProperty() {
        return this.metadata.getVersionProperty();
    }

    public boolean hasIdentifierProperty() {
        return this.metadata.hasIdentifierProperty();
    }

    public boolean hasNaturalIdentifier() {
        return this.metadata.hasNaturalIdentifier();
    }

    public boolean hasProxy() {
        return this.metadata.hasProxy();
    }

    public boolean hasSubclasses() {
        return this.metadata.hasSubclasses();
    }

    public boolean implementsLifecycle(EntityMode entityMode) {
        return this.metadata.implementsLifecycle(entityMode);
    }

    public boolean implementsValidatable(EntityMode entityMode) {
        return this.metadata.implementsValidatable(entityMode);
    }

    public Object instantiate(Serializable id, EntityMode entityMode) throws HibernateException {
        return this.metadata.instantiate(id, entityMode);
    }

    public boolean isInherited() {
        return this.metadata.isInherited();
    }

    public boolean isMutable() {
        return this.metadata.isMutable();
    }

    public boolean isVersioned() {
        return this.metadata.isVersioned();
    }

    public void setIdentifier(Object object, Serializable id, EntityMode entityMode) throws HibernateException {
        this.metadata.setIdentifier(object, id, entityMode);
    }

    public void setPropertyValue(Object object, String propertyName, Object value, EntityMode entityMode) throws HibernateException {
        this.metadata.setPropertyValue(object, propertyName, value, entityMode);
    }

    public void setPropertyValues(Object object, Object[] values, EntityMode entityMode) throws HibernateException {
        this.metadata.setPropertyValues(object, values, entityMode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindGeomProperty
    implements FinderStrategy<String, ClassMetadata> {
        private FindGeomProperty() {
        }

        @Override
        public String find(ClassMetadata metadata) throws FinderException {
            for (String prop : metadata.getPropertyNames()) {
                Type type = metadata.getPropertyType(prop);
                if (!Geometry.class.isAssignableFrom(type.getReturnedClass())) continue;
                return prop;
            }
            throw new FinderException("Could not find a Geometry-valued property in " + metadata.getEntityName());
        }
    }
}

