/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.hibernatespatial.test.DataSourceUtils;
import org.hibernatespatial.test.NativeSQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpectationsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExpectationsFactory.class);
    public static final String TEST_POLYGON_WKT = "POLYGON((0 0, 50 0, 100 100, 0 100, 0 0))";
    public static final String TEST_POINT_WKT = "POINT(0 0)";
    public static final int INTEGER = 1;
    public static final int DOUBLE = 2;
    public static final int GEOMETRY = 3;
    public static final int STRING = 4;
    public static final int BOOLEAN = 5;
    public static final int OBJECT = -1;
    private static final int TEST_SRID = 4326;
    private final DataSourceUtils dataSourceUtils;
    private static final int MAX_BYTE_LEN = 1024;

    public AbstractExpectationsFactory(DataSourceUtils dataSourceUtils) {
        this.dataSourceUtils = dataSourceUtils;
    }

    protected DataSourceUtils getDataSourceUtils() {
        return this.dataSourceUtils;
    }

    public int getTestSrid() {
        return 4326;
    }

    public Map<Integer, Integer> getDimension() throws SQLException {
        return this.retrieveExpected(this.createNativeDimensionSQL(), 1);
    }

    public Map<Integer, String> getAsText() throws SQLException {
        return this.retrieveExpected(this.createNativeAsTextStatement(), 4);
    }

    public Map<Integer, byte[]> getAsBinary() throws SQLException {
        return this.retrieveExpected(this.createNativeAsBinaryStatement(), -1);
    }

    public Map<Integer, String> getGeometryType() throws SQLException {
        return this.retrieveExpected(this.createNativeGeometryTypeStatement(), 4);
    }

    public Map<Integer, Integer> getSrid() throws SQLException {
        return this.retrieveExpected(this.createNativeSridStatement(), 1);
    }

    public Map<Integer, Boolean> getIsSimple() throws SQLException {
        return this.retrieveExpected(this.createNativeIsSimpleStatement(), 5);
    }

    public Map<Integer, Boolean> getIsEmpty() throws SQLException {
        return this.retrieveExpected(this.createNativeIsEmptyStatement(), 5);
    }

    public Map<Integer, Boolean> getIsNotEmpty() throws SQLException {
        return this.retrieveExpected(this.createNativeIsNotEmptyStatement(), 5);
    }

    public Map<Integer, Geometry> getBoundary() throws SQLException {
        return this.retrieveExpected(this.createNativeBoundaryStatement(), 3);
    }

    public Map<Integer, Geometry> getEnvelope() throws SQLException {
        return this.retrieveExpected(this.createNativeEnvelopeStatement(), 3);
    }

    public Map<Integer, Boolean> getWithin(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeWithinStatement(geom), 5);
    }

    public Map<Integer, Boolean> getEquals(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeEqualsStatement(geom), 5);
    }

    public Map<Integer, Boolean> getCrosses(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeCrossesStatement(geom), 5);
    }

    public Map<Integer, Boolean> getContains(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeContainsStatement(geom), 5);
    }

    public Map<Integer, Boolean> getDisjoint(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeDisjointStatement(geom), 5);
    }

    public Map<Integer, Boolean> getIntersects(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeIntersectsStatement(geom), 5);
    }

    public Map<Integer, Boolean> getTouches(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeTouchesStatement(geom), 5);
    }

    public Map<Integer, Boolean> getOverlaps(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeOverlapsStatement(geom), 5);
    }

    public Map<Integer, Boolean> getDwithin(Point geom, double distance) throws SQLException {
        return this.retrieveExpected(this.createNativeDwithinStatement(geom, distance), 5);
    }

    public Map<Integer, Boolean> havingSRID(int srid) throws SQLException {
        return this.retrieveExpected(this.createNativeHavingSRIDStatement(srid), 5);
    }

    public Map<Integer, Boolean> getRelate(Geometry geom, String matrix) throws SQLException {
        return this.retrieveExpected(this.createNativeRelateStatement(geom, matrix), 5);
    }

    public Map<Integer, Boolean> getFilter(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeFilterStatement(geom), 5);
    }

    public Map<Integer, Double> getDistance(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeDistanceStatement(geom), 2);
    }

    public Map<Integer, Geometry> getBuffer(Double distance) throws SQLException {
        return this.retrieveExpected(this.createNativeBufferStatement(distance), 3);
    }

    public Map<Integer, Geometry> getConvexHull(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeConvexHullStatement(geom), 3);
    }

    public Map<Integer, Geometry> getIntersection(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeIntersectionStatement(geom), 3);
    }

    public Map<Integer, Geometry> getDifference(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeDifferenceStatement(geom), 3);
    }

    public Map<Integer, Geometry> getSymDifference(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeSymDifferenceStatement(geom), 3);
    }

    public Map<Integer, Geometry> getGeomUnion(Geometry geom) throws SQLException {
        return this.retrieveExpected(this.createNativeGeomUnionStatement(geom), 3);
    }

    public Map<Integer, Geometry> getTransform(int epsg) throws SQLException {
        return this.retrieveExpected(this.createNativeTransformStatement(epsg), 3);
    }

    protected abstract NativeSQLStatement createNativeTouchesStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeOverlapsStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeRelateStatement(Geometry var1, String var2);

    protected abstract NativeSQLStatement createNativeDwithinStatement(Point var1, double var2);

    protected abstract NativeSQLStatement createNativeIntersectsStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeFilterStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeDistanceStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeDimensionSQL();

    protected abstract NativeSQLStatement createNativeBufferStatement(Double var1);

    protected abstract NativeSQLStatement createNativeConvexHullStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeIntersectionStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeDifferenceStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeSymDifferenceStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeGeomUnionStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeAsTextStatement();

    protected abstract NativeSQLStatement createNativeSridStatement();

    protected abstract NativeSQLStatement createNativeIsSimpleStatement();

    protected abstract NativeSQLStatement createNativeIsEmptyStatement();

    protected abstract NativeSQLStatement createNativeIsNotEmptyStatement();

    protected abstract NativeSQLStatement createNativeBoundaryStatement();

    protected abstract NativeSQLStatement createNativeEnvelopeStatement();

    protected abstract NativeSQLStatement createNativeAsBinaryStatement();

    protected abstract NativeSQLStatement createNativeGeometryTypeStatement();

    protected abstract NativeSQLStatement createNativeWithinStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeEqualsStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeCrossesStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeContainsStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeDisjointStatement(Geometry var1);

    protected abstract NativeSQLStatement createNativeTransformStatement(int var1);

    protected abstract NativeSQLStatement createNativeHavingSRIDStatement(int var1);

    protected Connection createConnection() throws SQLException {
        return this.dataSourceUtils.getConnection();
    }

    protected abstract Geometry decode(Object var1);

    public Polygon getTestPolygon() {
        WKTReader reader = new WKTReader();
        try {
            Polygon polygon = (Polygon)reader.read(TEST_POLYGON_WKT);
            polygon.setSRID(this.getTestSrid());
            return polygon;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Point getTestPoint() {
        WKTReader reader = new WKTReader();
        try {
            Point point = (Point)reader.read(TEST_POINT_WKT);
            point.setSRID(this.getTestSrid());
            return point;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Map<Integer, T> retrieveExpected(NativeSQLStatement nativeSQLStatement, int type) throws SQLException {
        Statement preparedStatement = null;
        Connection cn = null;
        HashMap<Integer, Object> expected = new HashMap<Integer, Object>();
        try {
            cn = this.createConnection();
            preparedStatement = nativeSQLStatement.prepare(cn);
            LOGGER.info("Native SQL is: " + preparedStatement.toString());
            ResultSet results = preparedStatement.executeQuery();
            block10: while (results.next()) {
                int id = results.getInt(1);
                switch (type) {
                    case 3: {
                        expected.put(id, this.decode(results.getObject(2)));
                        continue block10;
                    }
                    case 4: {
                        expected.put(id, results.getString(2));
                        continue block10;
                    }
                    case 1: {
                        expected.put(id, results.getLong(2));
                        continue block10;
                    }
                    case 2: {
                        Double value = results.getDouble(2);
                        if (results.wasNull()) {
                            value = null;
                        }
                        expected.put(id, value);
                        continue block10;
                    }
                    case 5: {
                        expected.put(id, results.getBoolean(2));
                        continue block10;
                    }
                }
                Object val = results.getObject(2);
                if (val instanceof Blob) {
                    val = ((Blob)val).getBytes(1L, 1024);
                }
                expected.put(id, val);
            }
            HashMap<Integer, Object> hashMap = expected;
            return hashMap;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (cn != null) {
                cn.close();
            }
        }
    }

    protected NativeSQLStatement createNativeSQLStatement(final String sql) {
        return new NativeSQLStatement(){

            public PreparedStatement prepare(Connection connection) throws SQLException {
                return connection.prepareStatement(sql);
            }
        };
    }

    protected NativeSQLStatement createNativeSQLStatementAllWKTParams(final String sql, final String wkt) {
        return new NativeSQLStatement(){

            public PreparedStatement prepare(Connection connection) throws SQLException {
                PreparedStatement pstmt = connection.prepareStatement(sql);
                for (int i = 1; i <= AbstractExpectationsFactory.this.numPlaceHoldersInSQL(sql); ++i) {
                    pstmt.setString(i, wkt);
                }
                return pstmt;
            }
        };
    }

    protected NativeSQLStatement createNativeSQLStatement(final String sql, final Object[] params) {
        return new NativeSQLStatement(){

            public PreparedStatement prepare(Connection connection) throws SQLException {
                PreparedStatement pstmt = connection.prepareStatement(sql);
                int i = 1;
                for (Object param : params) {
                    pstmt.setObject(i++, param);
                }
                return pstmt;
            }
        };
    }

    protected int numPlaceHoldersInSQL(String sql) {
        return sql.replaceAll("[^?]", "").length();
    }
}

