/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.hibernatespatial.test.EWKTReader;
import org.hibernatespatial.test.SQLExpressionTemplate;
import org.hibernatespatial.test.TestData;
import org.hibernatespatial.test.TestDataElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(DataSourceUtils.class);
    private final SQLExpressionTemplate sqlExpressionTemplate;
    private final String jdbcDriver;
    private final String jdbcUrl;
    private final String jdbcUser;
    private final String jdbcPass;
    private DataSource dataSource;

    public DataSourceUtils(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPass, SQLExpressionTemplate sqlExpressionTemplate) {
        this.jdbcDriver = jdbcDriver;
        this.jdbcUrl = jdbcUrl;
        this.jdbcUser = jdbcUser;
        this.jdbcPass = jdbcPass;
        this.sqlExpressionTemplate = sqlExpressionTemplate;
        this.createBasicDataSource();
    }

    public DataSourceUtils(String propertyFile, SQLExpressionTemplate template) {
        Properties properties = this.readProperties(propertyFile);
        this.jdbcUrl = properties.getProperty("jdbcUrl");
        this.jdbcDriver = properties.getProperty("jdbcDriver");
        this.jdbcUser = properties.getProperty("jdbcUser");
        this.jdbcPass = properties.getProperty("jdbcPass");
        this.sqlExpressionTemplate = template;
        this.createBasicDataSource();
    }

    private Properties readProperties(String propertyFile) {
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFile);
            if (is == null) {
                throw new RuntimeException(String.format("File %s not found on classpath.", propertyFile));
            }
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void createBasicDataSource() {
        BasicDataSource bds = new BasicDataSource();
        bds.setDriverClassName(this.jdbcDriver);
        bds.setUrl(this.jdbcUrl);
        bds.setUsername(this.jdbcUser);
        bds.setPassword(this.jdbcPass);
        this.dataSource = bds;
    }

    public void close() throws SQLException {
        ((BasicDataSource)this.dataSource).close();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        Connection cn = this.getDataSource().getConnection();
        cn.setAutoCommit(false);
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTestData() throws SQLException {
        Connection cn = null;
        try {
            cn = this.getDataSource().getConnection();
            cn.setAutoCommit(false);
            PreparedStatement pmt = cn.prepareStatement("delete from GEOMTEST");
            if (!pmt.execute()) {
                int updateCount = pmt.getUpdateCount();
                LOGGER.info("Removing " + updateCount + " rows.");
            }
            cn.commit();
            pmt.close();
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTestData(TestData testData) throws SQLException {
        Connection cn = null;
        try {
            cn = this.getDataSource().getConnection();
            cn.setAutoCommit(false);
            Statement stmt = cn.createStatement();
            for (TestDataElement testDataElement : testData) {
                String sql = this.sqlExpressionTemplate.toInsertSql(testDataElement);
                LOGGER.debug("adding stmt: " + sql);
                stmt.addBatch(sql);
            }
            int[] insCounts = stmt.executeBatch();
            cn.commit();
            stmt.close();
            LOGGER.info("Loaded " + DataSourceUtils.sum(insCounts) + " rows.");
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseSqlIn(String fileName) throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (is == null) {
            throw new RuntimeException("File " + fileName + " not found on Classpath.");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringWriter sw = new StringWriter();
            BufferedWriter writer = new BufferedWriter(sw);
            int c = reader.read();
            while (c != -1) {
                writer.write(c);
                c = reader.read();
            }
            writer.flush();
            String string = sw.toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStatement(String sql) throws SQLException {
        Connection cn = null;
        try {
            cn = this.getDataSource().getConnection();
            cn.setAutoCommit(false);
            PreparedStatement statement = cn.prepareStatement(sql);
            LOGGER.info("Executing statement: " + sql);
            statement.execute();
            cn.commit();
            statement.close();
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void afterCreateSchema() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Object> rawDbObjects(String type) {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        Connection cn = null;
        try {
            cn = this.getDataSource().getConnection();
            PreparedStatement pstmt = cn.prepareStatement("select id, geom from geomtest where type = ? order by id");
            pstmt.setString(1, type);
            ResultSet results = pstmt.executeQuery();
            while (results.next()) {
                Integer id = results.getInt(1);
                Object obj = results.getObject(2);
                map.put(id, obj);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {}
        }
        return map;
    }

    public Map<Integer, Geometry> expectedGeoms(String type, TestData testData) {
        HashMap<Integer, Geometry> result = new HashMap<Integer, Geometry>();
        EWKTReader parser = new EWKTReader();
        for (TestDataElement testDataElement : testData) {
            if (!testDataElement.type.equalsIgnoreCase(type)) continue;
            try {
                result.put(testDataElement.id, parser.read(testDataElement.wkt));
            }
            catch (ParseException e) {
                System.out.println(String.format("Parsing WKT fails for case %d : %s", testDataElement.id, testDataElement.wkt));
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static int sum(int[] insCounts) {
        int result = 0;
        for (int idx = 0; idx < insCounts.length; ++idx) {
            result += insCounts[idx];
        }
        return result;
    }
}

