/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.mgeom.MLineString;

public class EWKTReader {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String EQUALS = "=";
    private static final String SEMICOLON = ";";
    private GeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private StreamTokenizer tokenizer;
    private int dimension = -1;
    private Boolean hasM = null;

    public EWKTReader() {
        this((GeometryFactory)new MGeometryFactory());
    }

    public EWKTReader(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(String wellKnownText) throws ParseException {
        StringReader reader = new StringReader(wellKnownText);
        try {
            Geometry geometry = this.read(reader);
            return geometry;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry read(Reader reader) throws ParseException {
        try {
            EWKTReader eWKTReader = this;
            synchronized (eWKTReader) {
                if (this.tokenizer != null) {
                    throw new RuntimeException("EWKT-Reader is already in use.");
                }
                this.tokenizer = new StreamTokenizer(reader);
            }
            this.tokenizer.resetSyntax();
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.tokenizer.wordChars(160, 255);
            this.tokenizer.wordChars(48, 57);
            this.tokenizer.wordChars(45, 45);
            this.tokenizer.wordChars(43, 43);
            this.tokenizer.wordChars(46, 46);
            this.tokenizer.whitespaceChars(0, 32);
            this.tokenizer.commentChar(35);
            this.hasM = null;
            this.dimension = -1;
            eWKTReader = this.readGeometryTaggedText();
            return eWKTReader;
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
        finally {
            this.tokenizer = null;
        }
    }

    private MCoordinate[] getCoordinates() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new MCoordinate[0];
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        return coordinates.toArray(new MCoordinate[coordinates.size()]);
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        MCoordinate coord = new MCoordinate();
        coord.x = this.getNextNumber();
        coord.y = this.getNextNumber();
        Double thirdOrdinateValue = null;
        Double fourthOrdinateValue = null;
        if (this.dimension == 3) {
            thirdOrdinateValue = this.getNextNumber();
        } else if (this.dimension == 4) {
            thirdOrdinateValue = this.getNextNumber();
            fourthOrdinateValue = this.getNextNumber();
        } else if (this.dimension < 0) {
            if (this.isNumberNext()) {
                thirdOrdinateValue = this.getNextNumber();
            }
            if (this.isNumberNext()) {
                fourthOrdinateValue = this.getNextNumber();
            }
            if (fourthOrdinateValue != null) {
                this.dimension = 4;
                this.setHasM(true);
            } else if (thirdOrdinateValue != null) {
                this.dimension = 3;
                this.setHasM(Boolean.TRUE.equals(this.hasM));
            } else {
                this.dimension = 2;
                this.setHasM(false);
            }
        }
        switch (this.dimension) {
            case 2: {
                break;
            }
            case 3: {
                if (this.hasM.booleanValue()) {
                    coord.m = thirdOrdinateValue;
                    break;
                }
                coord.z = thirdOrdinateValue;
                break;
            }
            case 4: {
                if (this.hasM.booleanValue()) {
                    coord.z = thirdOrdinateValue;
                    coord.m = fourthOrdinateValue;
                    break;
                }
                throw new ParseException("Unsupported geometry dimension.");
            }
            default: {
                throw new ParseException("Unsupported geometry dimension.");
            }
        }
        this.precisionModel.makePrecise((Coordinate)coord);
        return coord;
    }

    private boolean isNumberNext() throws IOException {
        int type = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                try {
                    return Double.parseDouble(this.tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid number: " + this.tokenizer.sval);
                }
            }
        }
        this.parseError("number");
        return 0.0;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseError("EMPTY or (");
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(", or )");
        return null;
    }

    private String getNextCloser() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(R_PAREN);
        return null;
    }

    private int getSRID() throws IOException, ParseException {
        if (!this.getNextWord().equals(EQUALS)) {
            this.parseError(EQUALS);
            return 0;
        }
        int srid = Integer.parseInt(this.getNextWord());
        if (!this.getNextWord().equals(SEMICOLON)) {
            this.parseError(SEMICOLON);
            return 0;
        }
        return srid;
    }

    private String getNextWord() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = this.tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    return EMPTY;
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
            case 61: {
                return EQUALS;
            }
            case 59: {
                return SEMICOLON;
            }
        }
        this.parseError("word");
        return null;
    }

    private void parseError(String expected) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere((String)"Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere((String)"Unexpected EOL token");
        }
        String tokenStr = this.tokenString();
        throw new ParseException("Expected " + expected + " but found " + tokenStr);
    }

    private String tokenString() {
        switch (this.tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + this.tokenizer.sval + "'";
            }
        }
        return "'" + (char)this.tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText() throws IOException, ParseException {
        Point geom;
        String type = null;
        int srid = this.geometryFactory.getSRID();
        try {
            String firstWord = this.getNextWord();
            if ("SRID".equals(firstWord)) {
                srid = this.getSRID();
                type = this.getNextWord();
            } else {
                type = firstWord;
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (ParseException e) {
            return null;
        }
        if (type.equals("POINT")) {
            geom = this.readPointText();
        } else if (type.equals("POINTM")) {
            this.setHasM(true);
            geom = this.readPointText();
        } else if (type.equalsIgnoreCase("LINESTRING")) {
            geom = this.readLineStringText();
        } else if (type.equalsIgnoreCase("LINESTRINGM")) {
            this.setHasM(true);
            geom = this.readLineStringText();
        } else if (type.equalsIgnoreCase("LINEARRING")) {
            geom = this.readLinearRingText();
        } else if (type.equalsIgnoreCase("LINEARRINGM")) {
            this.setHasM(true);
            geom = this.readLinearRingText();
        } else if (type.equalsIgnoreCase("POLYGON")) {
            geom = this.readPolygonText();
        } else {
            if (type.equalsIgnoreCase("POLYGONM")) {
                throw new RuntimeException("PolygonM is not supported.");
            }
            if (type.equalsIgnoreCase("MULTIPOINT")) {
                geom = this.readMultiPointText();
            } else if (type.equalsIgnoreCase("MULTIPOINTM")) {
                this.setHasM(true);
                geom = this.readMultiPointText();
            } else if (type.equalsIgnoreCase("MULTILINESTRING")) {
                geom = this.readMultiLineStringText();
            } else if (type.equalsIgnoreCase("MULTILINESTRINGM")) {
                this.setHasM(true);
                geom = this.readMultiLineStringText();
            } else if (type.equalsIgnoreCase("MULTIPOLYGON")) {
                geom = this.readMultiPolygonText();
            } else {
                if (type.equalsIgnoreCase("MULTIPOLYGONM")) {
                    throw new RuntimeException("MultiPolygonM is not supported.");
                }
                if (type.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
                    geom = this.readGeometryCollectionText();
                } else if (type.equalsIgnoreCase("GEOMETRYCOLLECTIONM")) {
                    this.setHasM(true);
                    geom = this.readGeometryCollectionText();
                } else {
                    throw new ParseException("Unknown geometry type: " + type);
                }
            }
        }
        geom.setSRID(srid);
        return geom;
    }

    private void setHasM(boolean hasM) throws ParseException {
        if (this.hasM == null) {
            this.hasM = hasM;
        } else if (this.hasM != hasM) {
            throw new ParseException("Inkonsistent use of m-values.");
        }
    }

    private Point readPointText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPoint((Coordinate)null);
        }
        Point point = this.geometryFactory.createPoint(this.getPreciseCoordinate());
        this.getNextCloser();
        return point;
    }

    private LineString readLineStringText() throws IOException, ParseException {
        MCoordinate[] coords = this.getCoordinates();
        if (this.hasM != null && this.hasM.booleanValue()) {
            return ((MGeometryFactory)this.geometryFactory).createMLineString(coords);
        }
        return this.geometryFactory.createLineString((Coordinate[])coords);
    }

    private LinearRing readLinearRingText() throws IOException, ParseException {
        MCoordinate[] coords = this.getCoordinates();
        if (this.hasM.booleanValue()) {
            throw new RuntimeException("LinearRingM not supported.");
        }
        return this.geometryFactory.createLinearRing((Coordinate[])coords);
    }

    private MultiPoint readMultiPointText() throws IOException, ParseException {
        MCoordinate[] coords = this.getCoordinates();
        Point[] pts = this.toPoints((Coordinate[])coords);
        return this.geometryFactory.createMultiPoint(pts);
    }

    private Point[] toPoints(Coordinate[] coordinates) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < coordinates.length; ++i) {
            points.add(this.geometryFactory.createPoint(coordinates[i]));
        }
        return points.toArray(new Point[0]);
    }

    private Polygon readPolygonText() throws IOException, ParseException {
        this.setHasM(false);
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        LinearRing shell = this.readLinearRingText();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createPolygon(shell, holes.toArray(array));
    }

    private MultiLineString readMultiLineStringText() throws IOException, ParseException {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        String nextToken = this.getNextEmptyOrOpener();
        if (!nextToken.equals(EMPTY)) {
            LineString lineString = this.readLineStringText();
            lineStrings.add(lineString);
            nextToken = this.getNextCloserOrComma();
            while (nextToken.equals(COMMA)) {
                lineString = this.readLineStringText();
                lineStrings.add(lineString);
                nextToken = this.getNextCloserOrComma();
            }
        }
        if (this.hasM != null && this.hasM.booleanValue()) {
            MLineString[] mlines = lineStrings.toArray(new MLineString[lineStrings.size()]);
            return ((MGeometryFactory)this.geometryFactory).createMultiMLineString(mlines);
        }
        this.setHasM(false);
        LineString[] lines = lineStrings.toArray(new LineString[lineStrings.size()]);
        return this.geometryFactory.createMultiLineString(lines);
    }

    private MultiPolygon readMultiPolygonText() throws IOException, ParseException {
        this.setHasM(false);
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiPolygon(new Polygon[0]);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Polygon polygon = this.readPolygonText();
        polygons.add(polygon);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            polygon = this.readPolygonText();
            polygons.add(polygon);
            nextToken = this.getNextCloserOrComma();
        }
        Polygon[] array = new Polygon[polygons.size()];
        return this.geometryFactory.createMultiPolygon(polygons.toArray(array));
    }

    private GeometryCollection readGeometryCollectionText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        Geometry geometry = this.readGeometryTaggedText();
        geometries.add(geometry);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            geometry = this.readGeometryTaggedText();
            geometries.add(geometry);
            nextToken = this.getNextCloserOrComma();
        }
        Geometry[] array = new Geometry[geometries.size()];
        return this.geometryFactory.createGeometryCollection(geometries.toArray(array));
    }
}

