/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import org.hibernatespatial.test.EWKTReader;
import org.hibernatespatial.test.TestDataElement;
import org.hibernatespatial.test.TestFeature;

public class GeomEntity
implements TestFeature {
    private Integer id;
    private String type;
    private Geometry geom;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Geometry getGeom() {
        return this.geom;
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
    }

    public static GeomEntity createFrom(TestDataElement element) throws ParseException {
        EWKTReader reader = new EWKTReader();
        GeomEntity result = new GeomEntity();
        result.setId(element.id);
        Geometry geom = reader.read(element.wkt);
        geom.setSRID(element.srid);
        result.setGeom(geom);
        result.setType(element.type);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeomEntity geomEntity = (GeomEntity)o;
        return this.id == geomEntity.id;
    }

    public int hashCode() {
        return this.id;
    }
}

