/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import com.vividsolutions.jts.geom.Coordinate;
import org.hibernatespatial.Circle;
import org.junit.Assert;
import org.junit.Test;

public class TestCircle {
    @Test
    public void testCreateCircle() {
        Coordinate center = new Coordinate(0.0, 0.0);
        double radius = 5.0;
        Coordinate p1 = new Coordinate(3.0, 4.0);
        Coordinate p2 = new Coordinate(0.0, 5.0);
        Coordinate p3 = new Coordinate(-3.0, 4.0);
        Circle c0 = new Circle(center, radius);
        Circle c1 = new Circle(p1, p2, p3);
        Assert.assertEquals((Object)c0, (Object)c1);
        Assert.assertTrue((Double.compare(c1.getRadius(), radius) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c1.getCenter().equals2D(center));
        double distance = c1.distanceFromCenter(p3);
        Assert.assertTrue((Double.compare(c1.getRadius(), distance) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNormalize() {
        double actual;
        double expected = 0.0;
        double angleIncr = 0.7853981633974483;
        double twoPi = Math.PI * 2;
        int factor = 8;
        for (int i = 0; i <= factor; ++i) {
            expected = (double)i * angleIncr;
            actual = Circle.normalizeAngle((double)expected);
            Assert.assertEquals((double)actual, (double)expected, (double)Math.ulp(expected));
            double degrees = Math.toDegrees(actual);
            Assert.assertTrue((actual <= twoPi ? 1 : 0) != 0);
            Assert.assertTrue((degrees <= 360.0 ? 1 : 0) != 0);
        }
        factor = -8;
        for (int i = -1; i >= factor; --i) {
            double testAngle = (double)i * angleIncr;
            expected = twoPi + (double)i * angleIncr;
            actual = Circle.normalizeAngle((double)testAngle);
            Assert.assertEquals((double)actual, (double)expected, (double)Math.ulp(expected));
            double degrees = Math.toDegrees(actual);
            Assert.assertTrue((actual <= Math.PI * 2 ? 1 : 0) != 0);
            Assert.assertTrue((degrees <= 360.0 ? 1 : 0) != 0);
        }
        expected = 0.0;
        actual = Circle.normalizeAngle((double)(twoPi * 8.0));
        Assert.assertEquals((double)expected, (double)actual, (double)Math.ulp(expected));
        double testAngle = angleIncr + twoPi;
        expected = angleIncr;
        actual = Circle.normalizeAngle((double)testAngle);
        Assert.assertEquals((double)expected, (double)actual, (double)Math.ulp(expected));
        testAngle = angleIncr - twoPi;
        expected = angleIncr;
        actual = Circle.normalizeAngle((double)testAngle);
        Assert.assertEquals((double)expected, (double)actual, (double)Math.ulp(expected));
    }

    @Test
    public void testAngleDifference() {
        double a1 = 0.39269908169872414;
        double a2 = 0.7853981633974483;
        double diff = Circle.subtractAngles((double)a1, (double)a2);
        Assert.assertTrue((diff < Math.PI ? 1 : 0) != 0);
        diff = Circle.subtractAngles((double)a2, (double)a1);
        Assert.assertTrue((diff > Math.PI ? 1 : 0) != 0);
    }

    @Test
    public void testMajorArc() {
        Coordinate expectedCenter = new Coordinate(3.0, 0.0);
        double expectedRadius = 5.0;
        Coordinate p1 = new Coordinate(0.0, 4.0);
        Coordinate p2 = new Coordinate(8.0, 0.0);
        Coordinate p3 = new Coordinate(0.0, -4.0);
        Circle c = new Circle(p1, p2, p3);
        Assert.assertTrue((boolean)c.getCenter().equals2D(expectedCenter));
        Assert.assertTrue((Double.compare(c.getRadius(), expectedRadius) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testArcDirection() {
        Circle.Arc a;
        Circle c;
        Coordinate p2;
        int i;
        Coordinate[] coords = new Coordinate[]{new Coordinate(0.0, 5.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 0.0), new Coordinate(3.0, -4.0), new Coordinate(0.0, -5.0), new Coordinate(-3.0, -4.0), new Coordinate(-5.0, 0.0), new Coordinate(-3.0, 4.0)};
        for (i = 0; i < coords.length; ++i) {
            Coordinate p1 = coords[i];
            p2 = coords[(i + 1) % coords.length];
            Coordinate p3 = coords[(i + 2) % coords.length];
            c = new Circle(p1, p2, p3);
            a = c.createArc(p1, p2, p3);
            Assert.assertTrue((String)("Failed Points:" + p1 + ", " + p2 + ", " + p3), (boolean)a.isClockwise());
        }
        for (i = 0; i < coords.length; ++i) {
            Coordinate p3 = coords[i];
            p2 = coords[(i + 1) % coords.length];
            Coordinate p1 = coords[(i + 2) % coords.length];
            c = new Circle(p1, p2, p3);
            a = c.createArc(p1, p2, p3);
            Assert.assertFalse((String)("Failed Points:" + p1 + ", " + p2 + ", " + p3), (boolean)a.isClockwise());
        }
    }

    @Test
    public void testLinearize() {
        Coordinate p1 = new Coordinate(5.0, 0.0);
        Coordinate p2 = new Coordinate(4.0, 3.0);
        Coordinate p3 = new Coordinate(4.0, -3.0);
        Circle c = new Circle(p1, p2, p3);
        Coordinate[] results = c.linearizeArc(p3, p2, p1, c.getRadius() * 0.01);
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.length > 0 ? 1 : 0) != 0);
        for (Coordinate coord : results) {
            double error = c.getRadius() - c.distanceFromCenter(coord);
            Assert.assertTrue((Double.compare(error, 1.0E-4) < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLinearizeCircle() {
        Coordinate[] results;
        Coordinate p1 = new Coordinate(5.0, 0.0);
        Coordinate p2 = new Coordinate(4.0, 3.0);
        Coordinate p3 = new Coordinate(4.0, -3.0);
        Circle c = new Circle(p1, p2, p3);
        for (Coordinate coord : results = c.linearizeArc(p1, p2, p1, c.getRadius() * 0.01)) {
            double error = c.getRadius() - c.distanceFromCenter(coord);
            Assert.assertTrue((Double.compare(error, 1.0E-4) < 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testVerySmallArc() {
        double x1 = 4.54033778E8;
        double y1 = 6.01560635E8;
        double x2 = 4.54033765E8;
        double y2 = 6.01560632E8;
        double x3 = 4.54033761E8;
        double y3 = 6.01560638E8;
        Coordinate[] results = Circle.linearizeArc((double)x1, (double)y1, (double)x2, (double)y2, (double)x3, (double)y3);
        Assert.assertEquals((Object)new Coordinate(x1, y1), (Object)results[0]);
        Assert.assertEquals((Object)new Coordinate(x3, y3), (Object)results[results.length - 1]);
    }
}

