/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernatespatial.test.TestDataElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDataReader {
    public List<TestDataElement> read(String fileName) {
        if (fileName == null) {
            throw new RuntimeException("Null testsuite-suite data file specified.");
        }
        ArrayList<TestDataElement> testDataElements = new ArrayList<TestDataElement>();
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(this.getInputStream(fileName));
            this.addDataElements(document, testDataElements);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        return testDataElements;
    }

    protected void addDataElements(Document document, List<TestDataElement> testDataElements) {
        Element root = document.getRootElement();
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.addDataElement(element, testDataElements);
        }
    }

    protected void addDataElement(Element element, List<TestDataElement> testDataElements) {
        int id = Integer.valueOf(element.selectSingleNode("id").getText());
        String type = element.selectSingleNode("type").getText();
        String wkt = element.selectSingleNode("wkt").getText();
        int srid = Integer.valueOf(element.selectSingleNode("srid").getText());
        TestDataElement testDataElement = new TestDataElement(id, type, wkt, srid);
        testDataElements.add(testDataElement);
    }

    protected InputStream getInputStream(String fileName) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (is == null) {
            throw new RuntimeException(String.format("File %s not found on classpath.", fileName));
        }
        return is;
    }
}

