/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test;

import org.hibernate.cfg.Configuration;
import org.hibernate.testing.junit.functional.FunctionalTestCase;
import org.hibernatespatial.test.AbstractExpectationsFactory;
import org.hibernatespatial.test.DataSourceUtils;
import org.hibernatespatial.test.GeometryEquality;
import org.hibernatespatial.test.SQLExpressionTemplate;
import org.hibernatespatial.test.TestData;

public abstract class TestSupport {
    protected Configuration configuration;

    public DataSourceUtils createDataSourceUtil(Configuration configuration) {
        this.configuration = configuration;
        return new DataSourceUtils(this.driver(), this.url(), this.user(), this.passwd(), this.getSQLExpressionTemplate());
    }

    public GeometryEquality createGeometryEquality() {
        return new GeometryEquality();
    }

    public abstract TestData createTestData(FunctionalTestCase var1);

    public abstract AbstractExpectationsFactory createExpectationsFactory(DataSourceUtils var1);

    public abstract SQLExpressionTemplate getSQLExpressionTemplate();

    protected String driver() {
        return this.configuration.getProperty("hibernate.connection.driver_class");
    }

    protected String url() {
        return this.configuration.getProperty("hibernate.connection.url");
    }

    protected String user() {
        return this.configuration.getProperty("hibernate.connection.username");
    }

    protected String passwd() {
        return this.configuration.getProperty("hibernate.connection.password");
    }
}

