/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MCoordinateSequenceFactory;
import org.hibernatespatial.mgeom.MLineString;
import org.hibernatespatial.mgeom.MultiMLineString;

public class MultiMLineStringTest
extends TestCase {
    private final MCoordinateSequenceFactory mcfactory = MCoordinateSequenceFactory.instance();
    private final GeometryFactory geomfactory = new GeometryFactory((CoordinateSequenceFactory)this.mcfactory);
    protected MLineString ml1;
    protected MLineString ml2;
    protected MultiMLineString mm1;
    protected MultiMLineString mmsimple;
    protected MCoordinate lastco;

    public static void main(String[] args) {
        TestRunner.run(MultiMLineStringTest.class);
    }

    protected void setUp() throws Exception {
        MCoordinate mc4;
        super.setUp();
        MCoordinate mc0 = new MCoordinate(0.0, 0.0, 0.0, 0.0);
        MCoordinate mc1 = new MCoordinate(1.0, 0.0, 0.0, 0.1);
        MCoordinate mc2 = new MCoordinate(1.0, 1.0, 0.0, 0.2);
        MCoordinate mc3 = new MCoordinate(5.0, 1.0, 0.0, 0.3);
        this.lastco = mc4 = new MCoordinate(5.0, 3.0, 0.0, 0.4);
        MCoordinate[] m1 = new MCoordinate[]{mc0, mc1, mc2};
        MCoordinate[] m2 = new MCoordinate[]{mc3, mc4};
        CoordinateSequence mseq1 = this.mcfactory.create((Coordinate[])m1);
        this.ml1 = new MLineString(mseq1, this.geomfactory);
        CoordinateSequence mseq2 = this.mcfactory.create((Coordinate[])m2);
        this.ml2 = new MLineString(mseq2, this.geomfactory);
        this.mmsimple = new MultiMLineString(new MLineString[]{this.ml1}, 0.1, this.geomfactory);
        this.mm1 = new MultiMLineString(new MLineString[]{this.ml1, this.ml2}, 0.1, this.geomfactory);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMaxM() {
        MultiMLineStringTest.assertEquals((double)0.4, (double)this.mm1.getMaxM(), (double)1.0E-6);
    }

    public void testGetGeometryType() {
        MultiMLineStringTest.assertTrue((String)"wrong type reported", (boolean)this.mm1.getGeometryType().equalsIgnoreCase("multimlinestring"));
    }

    public void testGetDimension() {
    }

    public void testGetBoundary() {
    }

    public void testGetBoundaryDimension() {
    }

    public void testEqualsExactGeometrydouble() {
    }

    public void testMultiLineStringLineStringArrayPrecisionModelint() {
    }

    public void testMultiLineStringLineStringArrayGeometryFactory() {
    }

    public void testIsClosed() {
    }

    public void testClone() {
    }

    public void testInterpolate() {
        this.mm1.measureOnLength(false);
        Coordinate[] ca = this.mm1.getCoordinates();
        MultiMLineStringTest.assertTrue((String)"co 0 not OK", (((MCoordinate)ca[0]).m == 0.0 ? 1 : 0) != 0);
        MultiMLineStringTest.assertTrue((String)"co 1 not OK", (Math.abs(((MCoordinate)ca[1]).m - 1.0) < 1.0E-5 ? 1 : 0) != 0);
        MultiMLineStringTest.assertTrue((String)"co 2 not OK", (Math.abs(((MCoordinate)ca[2]).m - 2.0) < 1.0E-5 ? 1 : 0) != 0);
        MultiMLineStringTest.assertTrue((String)"co 3 not OK", (Math.abs(((MCoordinate)ca[3]).m - (2.0 + this.mm1.getMGap())) < 1.0E-5 ? 1 : 0) != 0);
        MultiMLineStringTest.assertTrue((String)"co 4 not OK", (Math.abs(((MCoordinate)ca[4]).m - (4.0 + this.mm1.getMGap())) < 1.0E-5 ? 1 : 0) != 0);
        double dist = this.mm1.getLength();
        MultiMLineStringTest.assertTrue((String)"interpolation not consistent with distance", (Math.abs(((MCoordinate)ca[4]).m - (dist += (double)(this.mm1.getNumGeometries() - 1) * this.mm1.getMGap())) < 1.0E-5 ? 1 : 0) != 0);
    }
}

