/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.hibernatespatial.mgeom.EventLocator;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MCoordinateSequenceFactory;
import org.hibernatespatial.mgeom.MGeometry;
import org.hibernatespatial.mgeom.MGeometryException;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.mgeom.MLineString;
import org.hibernatespatial.mgeom.MultiMLineString;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEventLocator {
    private PrecisionModel prec = new PrecisionModel(PrecisionModel.FIXED);
    private MGeometryFactory mgeomFactory = new MGeometryFactory(MCoordinateSequenceFactory.instance());
    private MultiMLineString incrML;

    @Before
    public void setUp() {
        MCoordinate[] coordinates = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0)};
        MLineString line1 = this.mgeomFactory.createMLineString(coordinates);
        MCoordinate[] coordinates2 = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)5.0), MCoordinate.create2dWithMeasure((double)6.0, (double)0.0, (double)6.0), MCoordinate.create2dWithMeasure((double)7.0, (double)0.0, (double)7.0)};
        MLineString line2 = this.mgeomFactory.createMLineString(coordinates2);
        MCoordinate[] coordinates3 = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)9.0, (double)0.0, (double)9.0), MCoordinate.create2dWithMeasure((double)10.0, (double)0.0, (double)10.0), MCoordinate.create2dWithMeasure((double)11.0, (double)0.0, (double)11.0)};
        MLineString line3 = this.mgeomFactory.createMLineString(coordinates2);
        this.incrML = this.mgeomFactory.createMultiMLineString(new MLineString[]{line1, line2});
    }

    @Test
    public void test_event_starts_at_end_of_component() throws MGeometryException {
        MultiMLineString result = EventLocator.getLinearGeometry((MGeometry)this.incrML, (double)4.0, (double)5.5);
        Assert.assertNotNull((Object)result);
        junit.framework.Assert.assertEquals((int)1, (int)result.getNumGeometries());
        junit.framework.Assert.assertEquals((int)2, (int)result.getCoordinates().length);
        Coordinate[] coordinates = result.getCoordinates();
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)5.0), (Object)((MCoordinate)coordinates[0]));
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.5, (double)0.0, (double)5.5), (Object)((MCoordinate)coordinates[1]));
    }

    @Test
    public void test_event_ends_at_begin_of_component() throws MGeometryException {
        MultiMLineString result = EventLocator.getLinearGeometry((MGeometry)this.incrML, (double)3.0, (double)5.0);
        Assert.assertNotNull((Object)result);
        junit.framework.Assert.assertEquals((int)1, (int)result.getNumGeometries());
        junit.framework.Assert.assertEquals((int)2, (int)result.getCoordinates().length);
        Coordinate[] coordinates = result.getCoordinates();
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), (Object)((MCoordinate)coordinates[0]));
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)((MCoordinate)coordinates[1]));
    }

    @Test
    public void test_event_ends_at_end_of_component() throws MGeometryException {
        MultiMLineString result = EventLocator.getLinearGeometry((MGeometry)this.incrML, (double)4.5, (double)7.0);
        Assert.assertNotNull((Object)result);
        junit.framework.Assert.assertEquals((int)1, (int)result.getNumGeometries());
        junit.framework.Assert.assertEquals((int)3, (int)result.getCoordinates().length);
        Coordinate[] coordinates = result.getCoordinates();
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)5.0), (Object)((MCoordinate)coordinates[0]));
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)6.0, (double)0.0, (double)6.0), (Object)((MCoordinate)coordinates[1]));
        junit.framework.Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)7.0, (double)0.0, (double)7.0), (Object)((MCoordinate)coordinates[2]));
    }

    @Test
    public void test_locator_result_has_same_srid_as_input_mgeometry() throws MGeometryException {
        this.incrML.setSRID(123);
        MultiMLineString result = EventLocator.getLinearGeometry((MGeometry)this.incrML, (double)4.5, (double)7.0);
        junit.framework.Assert.assertEquals((int)123, (int)result.getSRID());
    }
}

