/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.test.mgeom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.PrecisionModel;
import junit.framework.Assert;
import org.hibernatespatial.mgeom.MCoordinate;
import org.hibernatespatial.mgeom.MCoordinateSequenceFactory;
import org.hibernatespatial.mgeom.MGeometryException;
import org.hibernatespatial.mgeom.MGeometryFactory;
import org.hibernatespatial.mgeom.MLineString;
import org.junit.Before;
import org.junit.Test;

public class TestMLineStringGetCoordinatesBetween {
    MLineString incrLine;
    MLineString decLine;
    MLineString emptyLine;
    MLineString nonMonotoneLine;
    MLineString partiallyConstantIncreasing;
    MLineString partiallyConstantDecreasing;
    private PrecisionModel prec = new PrecisionModel(PrecisionModel.FIXED);
    private MGeometryFactory mgeomFactory = new MGeometryFactory(MCoordinateSequenceFactory.instance());

    @Before
    public void setUp() {
        MCoordinate[] coordinates = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0)};
        this.incrLine = this.mgeomFactory.createMLineString(coordinates);
        coordinates = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0)};
        this.decLine = this.mgeomFactory.createMLineString(coordinates);
        coordinates = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)1.0), MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)3.0), MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)5.0), MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)1.5)};
        this.nonMonotoneLine = this.mgeomFactory.createMLineString(coordinates);
        coordinates = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)3.0), MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0)};
        this.partiallyConstantIncreasing = this.mgeomFactory.createMLineString(coordinates);
        coordinates = new MCoordinate[]{MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)3.0), MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0)};
        this.partiallyConstantDecreasing = this.mgeomFactory.createMLineString(coordinates);
    }

    @Test
    public void test_measure_inside_monotone_increasing() throws MGeometryException {
        CoordinateSequence[] result = this.incrLine.getCoordinatesBetween(0.5, 3.5);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[crds.length - 1]);
        result = this.incrLine.getCoordinatesBetween(1.0, 3.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)3, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), (Object)crds[2]);
        result = this.incrLine.getCoordinatesBetween(0.0, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[4]);
        result = this.incrLine.getCoordinatesBetween(0.5, 1.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)3, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.5, (double)0.0, (double)1.5), (Object)crds[crds.length - 1]);
        result = this.incrLine.getCoordinatesBetween(3.5, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.5), (Object)crds[crds.length - 1]);
        result = this.incrLine.getCoordinatesBetween(3.5, 3.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.7, (double)0.0, (double)3.7), (Object)crds[1]);
        result = this.incrLine.getCoordinatesBetween(0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[1]);
        result = this.incrLine.getCoordinatesBetween(-0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[1]);
        result = this.incrLine.getCoordinatesBetween(3.5, 4.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[1]);
    }

    @Test
    public void test_measure_inside_partially_constant_increasing() throws MGeometryException {
        CoordinateSequence[] result = this.partiallyConstantIncreasing.getCoordinatesBetween(0.5, 2.5);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)2.5), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(1.0, 3.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)4, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)3.0), (Object)crds[3]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(0.0, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)6, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), (Object)crds[5]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(0.5, 1.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)3, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.5, (double)0.0, (double)1.5), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(1.5, 2.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)4, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.5, (double)0.0, (double)1.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)2.5), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(3.5, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(3.5, 3.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.7, (double)0.0, (double)3.7), (Object)crds[1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(-0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[1]);
        result = this.partiallyConstantIncreasing.getCoordinatesBetween(3.5, 4.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), (Object)crds[1]);
    }

    @Test
    public void test_measures_monotone_decreasing() throws MGeometryException {
        CoordinateSequence[] result = this.decLine.getCoordinatesBetween(0.5, 3.5);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[crds.length - 1]);
        result = this.decLine.getCoordinatesBetween(1.0, 3.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)3, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), (Object)crds[2]);
        result = this.decLine.getCoordinatesBetween(0.0, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)3.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[4]);
        result = this.decLine.getCoordinatesBetween(0.5, 1.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)3, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.5, (double)0.0, (double)1.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[crds.length - 1]);
        result = this.decLine.getCoordinatesBetween(3.5, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[crds.length - 1]);
        result = this.decLine.getCoordinatesBetween(3.5, 3.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.7, (double)0.0, (double)3.7), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[1]);
        result = this.decLine.getCoordinatesBetween(0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[1]);
        result = this.decLine.getCoordinatesBetween(-0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[1]);
        result = this.decLine.getCoordinatesBetween(3.5, 4.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[0]);
    }

    @Test
    public void test_measures_partially_constant_decreasing() throws MGeometryException {
        CoordinateSequence[] result = this.partiallyConstantDecreasing.getCoordinatesBetween(0.5, 3.5);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)6, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(1.0, 3.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)4, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)3.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)2.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), (Object)crds[2]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.0, (double)0.0, (double)1.0), (Object)crds[3]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(0.0, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)6, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)3.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[5]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(0.5, 1.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)3, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.5, (double)0.0, (double)1.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(1.5, 2.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)4, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)2.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.0, (double)0.0, (double)2.0), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.0, (double)0.0, (double)2.0), (Object)crds[2]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)1.5, (double)0.0, (double)1.5), (Object)crds[3]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(3.5, 4.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[crds.length - 1]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(3.5, 3.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.7, (double)0.0, (double)3.7), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[1]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[1]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(-0.5, 0.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.7, (double)0.0, (double)0.7), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[1]);
        result = this.partiallyConstantDecreasing.getCoordinatesBetween(3.5, 4.7);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)2, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.5, (double)0.0, (double)3.5), (Object)crds[1]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)5.0, (double)0.0, (double)4.0), (Object)crds[0]);
    }

    @Test
    public void test_measure_outside_monotone_increasing() throws MGeometryException {
        CoordinateSequence[] result = this.incrLine.getCoordinatesBetween(-1.5, -0.5);
        Assert.assertEquals((int)1, (int)result.length);
        Assert.assertEquals((int)0, (int)result[0].size());
        result = this.incrLine.getCoordinatesBetween(10.0, 20.0);
        Assert.assertEquals((int)1, (int)result.length);
        Assert.assertEquals((int)0, (int)result[0].size());
    }

    @Test
    public void test_measure_outside_monotone_decreasing() throws MGeometryException {
        CoordinateSequence[] result = this.decLine.getCoordinatesBetween(-1.5, -0.5);
        Assert.assertEquals((int)1, (int)result.length);
        Assert.assertEquals((int)0, (int)result[0].size());
        result = this.decLine.getCoordinatesBetween(10.0, 20.0);
        Assert.assertEquals((int)1, (int)result.length);
        Assert.assertEquals((int)0, (int)result[0].size());
    }

    @Test
    public void test_measure_overlap_monotone_increasing() throws MGeometryException {
        CoordinateSequence[] result = this.incrLine.getCoordinatesBetween(-0.5, 5.0);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[crds.length - 1]);
        result = this.incrLine.getCoordinatesBetween(0.5, 5.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[crds.length - 1]);
        result = this.incrLine.getCoordinatesBetween(-1.0, 2.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)4, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.5, (double)0.0, (double)2.5), (Object)crds[crds.length - 1]);
        result = this.incrLine.getCoordinatesBetween(4.0, 5.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)1, (int)crds.length);
    }

    @Test
    public void test_measure_overlap_monotone_decreasing() throws MGeometryException {
        CoordinateSequence[] result = this.decLine.getCoordinatesBetween(-0.5, 5.0);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[crds.length - 1]);
        result = this.decLine.getCoordinatesBetween(0.5, 5.0);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)4.0, (double)0.0, (double)4.0), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[crds.length - 1]);
        result = this.decLine.getCoordinatesBetween(-1.0, 2.5);
        Assert.assertEquals((int)1, (int)result.length);
        crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)4, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)2.5, (double)0.0, (double)2.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.0, (double)0.0, (double)0.0), (Object)crds[crds.length - 1]);
    }

    @Test
    public void test_measure_inverse_monotone_increasing() throws MGeometryException {
        CoordinateSequence[] result = this.incrLine.getCoordinatesBetween(3.5, 0.5);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[crds.length - 1]);
    }

    @Test
    public void test_measure_inverse_monotone_decreasing() throws MGeometryException {
        CoordinateSequence[] result = this.decLine.getCoordinatesBetween(3.5, 0.5);
        Assert.assertEquals((int)1, (int)result.length);
        Coordinate[] crds = result[0].toCoordinateArray();
        Assert.assertEquals((int)5, (int)crds.length);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)3.5, (double)0.0, (double)3.5), (Object)crds[0]);
        Assert.assertEquals((Object)MCoordinate.create2dWithMeasure((double)0.5, (double)0.0, (double)0.5), (Object)crds[crds.length - 1]);
    }

    @Test
    public void test_fail_on_non_monotone() throws MGeometryException {
        try {
            this.nonMonotoneLine.getCoordinatesBetween(0.5, 10.0);
            Assert.fail((String)"Needs to throw an IllegalArgumentException on non-monotone linestrings.");
        }
        catch (MGeometryException e) {
            Assert.assertEquals((int)e.getType(), (int)1);
        }
    }
}

