/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.testsuite;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.testing.junit.functional.FunctionalTestCase;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.test.AbstractExpectationsFactory;
import org.hibernatespatial.test.DataSourceUtils;
import org.hibernatespatial.test.GeometryEquality;
import org.hibernatespatial.test.TestData;
import org.hibernatespatial.test.TestSupport;
import org.hibernatespatial.testsuite.TestSupportFactories;
import org.junit.Assert;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpatialFunctionalTestCase
extends FunctionalTestCase {
    protected TestData testData;
    protected DataSourceUtils dataSourceUtils;
    protected GeometryEquality geometryEquality;
    protected AbstractExpectationsFactory expectationsFactory;

    public SpatialFunctionalTestCase(String string) {
        super(string);
    }

    public void insertTestData() {
        try {
            this.dataSourceUtils.insertTestData(this.testData);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllTestEntities() {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            String hql = "delete from GeomEntity";
            Query q = session.createQuery(hql);
            q.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void prepareTest() {
        try {
            TestSupport tsFactory = TestSupportFactories.instance().getTestSupportFactory(this.getDialect());
            Configuration cfg = this.getCfg();
            this.dataSourceUtils = tsFactory.createDataSourceUtil(cfg);
            this.expectationsFactory = tsFactory.createExpectationsFactory(this.dataSourceUtils);
            this.testData = tsFactory.createTestData((FunctionalTestCase)this);
            this.geometryEquality = tsFactory.createGeometryEquality();
            this.dataSourceUtils.afterCreateSchema();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanupTest() throws SQLException {
        this.dataSourceUtils.close();
    }

    public Connection getConnection() throws SQLException {
        return this.dataSourceUtils.getConnection();
    }

    public String getBaseForMappings() {
        return "";
    }

    public String[] getMappings() {
        return new String[]{"GeomEntity.hbm.xml"};
    }

    public boolean isSupportedByDialect(SpatialFunction spatialFunction) {
        SpatialDialect dialect = (SpatialDialect)this.getDialect();
        return dialect.supports(spatialFunction);
    }

    public boolean dialectSupportsFiltering() {
        SpatialDialect dialect = (SpatialDialect)this.getDialect();
        return dialect.supportsFiltering();
    }

    protected abstract Logger getLogger();

    protected <T> void addQueryResults(Map<Integer, T> result, Query query) {
        List rows = query.list();
        if (rows.size() == 0) {
            this.getLogger().warn("No results returned for query!!");
        }
        for (Object[] row : rows) {
            Integer id = (Integer)row[0];
            Object val = row[1];
            result.put(id, val);
        }
    }

    protected <T> void compare(Map<Integer, T> expected, Map<Integer, T> received) {
        for (Integer id : expected.keySet()) {
            this.getLogger().debug("Case :" + id);
            this.getLogger().debug("expected: " + expected.get(id));
            this.getLogger().debug("received: " + received.get(id));
            this.compare(id, expected.get(id), received.get(id));
        }
    }

    protected void compare(Integer id, Object expected, Object received) {
        SpatialFunctionalTestCase.assertTrue((expected != null || expected == null && received == null ? 1 : 0) != 0);
        if (expected instanceof byte[]) {
            Assert.assertArrayEquals((String)("Failure on testsuite-suite for case " + id), (byte[])((byte[])expected), (byte[])((byte[])received));
        } else if (expected instanceof Geometry) {
            if (!(received instanceof Geometry)) {
                SpatialFunctionalTestCase.fail((String)("Expected a Geometry, but received an object of type " + received.getClass().getCanonicalName()));
            }
            SpatialFunctionalTestCase.assertTrue((String)("Failure on testsuite-suite for case " + id), (boolean)this.geometryEquality.test((Geometry)expected, (Geometry)received));
        } else if (expected instanceof Long) {
            SpatialFunctionalTestCase.assertEquals((String)("Failure on testsuite-suite for case " + id), (Object)((Long)expected).intValue(), (Object)received);
        } else {
            SpatialFunctionalTestCase.assertEquals((String)("Failure on testsuite-suite for case " + id), (Object)expected, (Object)received);
        }
    }
}

