/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.testsuite;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernatespatial.HBSpatialExtension;
import org.hibernatespatial.pojo.AutoMapper;
import org.hibernatespatial.pojo.ClassInfo;
import org.hibernatespatial.pojo.FeatureMapper;
import org.hibernatespatial.pojo.MissingIdentifierException;
import org.hibernatespatial.pojo.NamingStrategy;
import org.hibernatespatial.pojo.SimpleNamingStrategy;
import org.hibernatespatial.pojo.TableNotFoundException;
import org.hibernatespatial.pojo.TypeMapper;
import org.hibernatespatial.testsuite.SpatialFunctionalTestCase;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAutoMapper
extends SpatialFunctionalTestCase {
    private static Logger LOGGER = LoggerFactory.getLogger(TestAutoMapper.class);
    private static boolean WRITE_MAPPING = false;
    private SessionFactory sessionFactory;

    public TestAutoMapper(String string) {
        super(string);
    }

    public SessionFactory buildSessionFactory(Configuration config) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("geomtest");
            Document mappingdocument = AutoMapper.map((Connection)conn, null, null, tables);
            if (WRITE_MAPPING) {
                this.writeToFile(mappingdocument);
            }
            config.addXML(mappingdocument.asXML());
            return config.buildSessionFactory();
        }
        catch (Exception e) {
            try {
                conn.close();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    private void writeToFile(Document mappingdocument) {
        try {
            File f = File.createTempFile("testsuite-suite-hs-automapper", ".xml");
            FileWriter writer = new FileWriter(f);
            mappingdocument.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void prepareTest() {
        super.prepareTest();
        if (!this.appliesTo(this.getDialect())) {
            return;
        }
        this.insertTestData();
        Configuration cfg = this.getCfg();
        cfg.setProperty("hibernate.hbm2ddl.auto", "update");
        this.sessionFactory = this.buildSessionFactory(cfg);
    }

    public void cleanupTest() {
        this.sessionFactory.close();
    }

    public Session openMappedSession() {
        return this.sessionFactory.openSession();
    }

    @Test
    public void test_automapper() throws Exception {
        ClassInfo cInfo;
        FeatureMapper fMapper;
        DatabaseMetaData dmd;
        TypeMapper typeMapper;
        SimpleNamingStrategy naming;
        PreparedStatement pstmt;
        if (!(this.getDialect() instanceof PostgreSQLDialect)) {
            return;
        }
        Session session = this.openMappedSession();
        try {
            List tables = AutoMapper.getMappedTables();
            TestAutoMapper.assertFalse((boolean)tables.isEmpty());
            for (String[] tncomp : tables) {
                Class entityClass = AutoMapper.getClass((String)tncomp[0], (String)tncomp[1], (String)tncomp[2]);
                Criteria c = session.createCriteria(entityClass);
                List results = c.list();
                TestAutoMapper.assertTrue((results.size() > 1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.close();
        }
        List attributes = AutoMapper.getAttributes(null, null, (String)"geomtest");
        TestAutoMapper.assertTrue((boolean)attributes.contains("id"));
        TestAutoMapper.assertTrue((boolean)attributes.contains("type"));
        TestAutoMapper.assertTrue((boolean)attributes.contains("geom"));
        TestAutoMapper.assertEquals((int)3, (int)attributes.size());
        String identifier = AutoMapper.getIdAttribute(null, null, (String)"geomtest");
        TestAutoMapper.assertEquals((String)"id", (String)identifier);
        String geometryAttribute = AutoMapper.getGeometryAttribute(null, null, (String)"geomtest");
        TestAutoMapper.assertEquals((String)"geom", (String)geometryAttribute);
        String methodName = AutoMapper.getAttributeSetterName(null, null, (String)"geomtest", (String)"geom");
        TestAutoMapper.assertEquals((String)"setGeom", (String)methodName);
        methodName = AutoMapper.getAttributeSetterName(null, null, (String)"geomtest", (String)"id");
        TestAutoMapper.assertEquals((String)"setId", (String)methodName);
        methodName = AutoMapper.getAttributeSetterName(null, null, (String)"geomtest", (String)"type");
        TestAutoMapper.assertEquals((String)"setType", (String)methodName);
        methodName = AutoMapper.getAttributeGetterName(null, null, (String)"geomtest", (String)"geom");
        TestAutoMapper.assertEquals((String)"getGeom", (String)methodName);
        methodName = AutoMapper.getAttributeGetterName(null, null, (String)"geomtest", (String)"id");
        TestAutoMapper.assertEquals((String)"getId", (String)methodName);
        methodName = AutoMapper.getAttributeGetterName(null, null, (String)"geomtest", (String)"type");
        TestAutoMapper.assertEquals((String)"getType", (String)methodName);
        try {
            methodName = AutoMapper.getAttributeGetterName(null, null, (String)"geomtest", (String)"nonexisting");
            TestAutoMapper.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            TestAutoMapper.fail();
        }
        try {
            methodName = AutoMapper.getAttributeGetterName(null, null, (String)"geomtest", null);
            TestAutoMapper.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            TestAutoMapper.fail();
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("create table mucomp (c1 int not null, c2 int not null, c3 char(10))");
            pstmt.execute();
            pstmt = conn.prepareStatement("alter table mucomp add primary key (c1, c2)");
            pstmt.execute();
            conn.commit();
            naming = new SimpleNamingStrategy();
            typeMapper = new TypeMapper(HBSpatialExtension.getDefaultSpatialDialect().getDbGeometryTypeName());
            dmd = conn.getMetaData();
            fMapper = new FeatureMapper((NamingStrategy)naming, typeMapper);
            try {
                cInfo = fMapper.createClassInfo(null, "public", "mucomp", dmd);
                TestAutoMapper.fail((String)"Attempt to map class with multiple primary keys");
            }
            catch (TableNotFoundException e) {
                TestAutoMapper.fail((String)"TableNotFoundException thrown");
            }
            catch (MissingIdentifierException e) {
            }
            catch (Exception e) {
                TestAutoMapper.fail((String)"MissingIdentifierException expected");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (conn != null) {
                PreparedStatement delTabStmt = conn.prepareStatement("drop table mucomp");
                delTabStmt.execute();
                conn.commit();
                conn.close();
            }
        }
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("create table nopkey (c1 int, c2 int, c3 char(10))");
            pstmt.execute();
            naming = new SimpleNamingStrategy();
            typeMapper = new TypeMapper(HBSpatialExtension.getDefaultSpatialDialect().getDbGeometryTypeName());
            dmd = conn.getMetaData();
            fMapper = new FeatureMapper((NamingStrategy)naming, typeMapper);
            try {
                cInfo = fMapper.createClassInfo(null, "public", "nopkey", dmd);
                TestAutoMapper.fail((String)"Attempt to map class with no primary key");
            }
            catch (TableNotFoundException e) {
                TestAutoMapper.fail((String)"TableNotFoundException thrown");
            }
            catch (MissingIdentifierException e) {
            }
            catch (Exception e) {
                TestAutoMapper.fail((String)"MissingIdentifierException expected");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (conn != null) {
                PreparedStatement delTabStmt = conn.prepareStatement("drop table nopkey");
                delTabStmt.execute();
                conn.close();
            }
        }
        try {
            conn = this.getConnection();
            pstmt = conn.prepareStatement("create table unik (c1 int, c2 int, c3 char(10))");
            pstmt.execute();
            pstmt = conn.prepareStatement("create unique index un_idx on unik(c1)");
            pstmt.execute();
            naming = new SimpleNamingStrategy();
            typeMapper = new TypeMapper(HBSpatialExtension.getDefaultSpatialDialect().getDbGeometryTypeName());
            dmd = conn.getMetaData();
            fMapper = new FeatureMapper((NamingStrategy)naming, typeMapper);
            try {
                cInfo = fMapper.createClassInfo(null, "public", "unik", dmd);
                TestAutoMapper.assertEquals((String)"c1", (String)cInfo.getIdAttribute().getColumnName());
            }
            catch (TableNotFoundException e) {
                TestAutoMapper.fail((String)"TableNotFoundException thrown");
            }
            catch (MissingIdentifierException e) {
                TestAutoMapper.fail((String)"Unique index not accepted as primary key");
            }
            catch (Exception e) {
                TestAutoMapper.fail((String)"MissingIdentifierException expected");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (conn != null) {
                PreparedStatement delTabStmt = conn.prepareStatement("drop table unik");
                delTabStmt.execute();
                conn.close();
            }
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

