/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.testsuite;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.type.Type;
import org.hibernatespatial.GeometryUserType;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.testsuite.SpatialFunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSpatialFunctions
extends SpatialFunctionalTestCase {
    private static Logger LOGGER = LoggerFactory.getLogger(TestSpatialFunctions.class);

    public TestSpatialFunctions(String string) {
        super(string);
    }

    @Override
    public void prepareTest() {
        super.prepareTest();
        this.insertTestData();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public void testSpatialFunctions() throws Exception {
        this.dimension();
        this.astext();
        this.asbinary();
        this.geometrytype();
        this.srid();
        this.issimple();
        this.isempty();
        this.boundary();
        this.envelope();
        this.within();
        this.equals();
        this.crosses();
        this.contains();
        this.disjoint();
        this.intersects();
        this.overlaps();
        this.touches();
        this.relate();
        this.distance();
        this.buffer();
        this.convexhull();
        this.intersection();
        this.difference();
        this.symdifference();
        this.geomunion();
        this.dwithin();
        this.transform();
    }

    public void dimension() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.dimension)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getDimension();
        String hql = "SELECT id, dimension(geom) FROM GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void astext() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.astext)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getAsText();
        String hql = "SELECT id, astext(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void asbinary() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.asbinary)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getAsBinary();
        String hql = "SELECT id, asbinary(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void geometrytype() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.geometrytype)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getGeometryType();
        String hql = "SELECT id, geometrytype(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void srid() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.srid)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getSrid();
        String hql = "SELECT id, srid(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void issimple() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.issimple)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIsSimple();
        String hql = "SELECT id, issimple(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void isempty() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.isempty)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIsEmpty();
        String hql = "SELECT id, isEmpty(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void boundary() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.boundary)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getBoundary();
        String hql = "SELECT id, boundary(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void envelope() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.envelope)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getEnvelope();
        String hql = "SELECT id, envelope(geom) from GeomEntity";
        this.retrieveHQLResultsAndCompare(dbexpected, hql);
    }

    public void within() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.within)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getWithin((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, within(geom, :filter) from GeomEntity where within(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void equals() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.equals)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getEquals((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, equals(geom, :filter) from GeomEntity where equals(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void crosses() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.crosses)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getCrosses((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, crosses(geom, :filter) from GeomEntity where crosses(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void contains() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.contains)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getContains((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, contains(geom, :filter) from GeomEntity where contains(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void disjoint() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.disjoint)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getDisjoint((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, disjoint(geom, :filter) from GeomEntity where disjoint(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void intersects() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.intersects)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIntersects((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, intersects(geom, :filter) from GeomEntity where intersects(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void overlaps() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.overlaps)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getOverlaps((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, overlaps(geom, :filter) from GeomEntity where overlaps(geom, :filter) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void touches() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.touches)) {
            return;
        }
        String hql = "SELECT id, touches(geom, :filter) from GeomEntity where touches(geom, :filter) = true and srid(geom) = 4326";
        Map dbexpected = this.expectationsFactory.getTouches((Geometry)this.expectationsFactory.getTestPolygon());
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void relate() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.relate)) {
            return;
        }
        String matrix = "T*T***T**";
        Map dbexpected = this.expectationsFactory.getRelate((Geometry)this.expectationsFactory.getTestPolygon(), matrix);
        String hql = "SELECT id, relate(geom, :filter, :matrix) from GeomEntity where relate(geom, :filter, :matrix) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        params.put("matrix", matrix);
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
        matrix = "FF*FF****";
        dbexpected = this.expectationsFactory.getRelate((Geometry)this.expectationsFactory.getTestPolygon(), matrix);
        params.put("matrix", matrix);
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void distance() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.distance)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getDistance((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, distance(geom, :filter) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void buffer() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.buffer)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getBuffer(Double.valueOf(1.0));
        String hql = "SELECT id, buffer(geom, :distance) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("distance", 1.0);
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void convexhull() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.convexhull)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getConvexHull((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, convexhull(geomunion(geom, :polygon)) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("polygon", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void intersection() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.intersection)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIntersection((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, intersection(geom, :polygon) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("polygon", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void difference() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.difference)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getDifference((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, difference(geom, :polygon) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("polygon", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void symdifference() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.symdifference)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getSymDifference((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, symdifference(geom, :polygon) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("polygon", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void geomunion() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.geomunion)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getGeomUnion((Geometry)this.expectationsFactory.getTestPolygon());
        String hql = "SELECT id, geomunion(geom, :polygon) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("polygon", this.expectationsFactory.getTestPolygon());
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void dwithin() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.dwithin)) {
            return;
        }
        double distance = 30.0;
        Map dbexpected = this.expectationsFactory.getDwithin(this.expectationsFactory.getTestPoint(), distance);
        String hql = "SELECT id, dwithin(geom, :filter, :distance) from GeomEntity where dwithin(geom, :filter, :distance) = true and srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("filter", this.expectationsFactory.getTestPoint());
        params.put("distance", 30.0);
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public void transform() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.transform)) {
            return;
        }
        int epsg = 4324;
        Map dbexpected = this.expectationsFactory.getTransform(epsg);
        String hql = "SELECT id, transform(geom, :epsg) from GeomEntity where srid(geom) = 4326";
        Map<String, Object> params = this.createQueryParams("epsg", epsg);
        this.retrieveHQLResultsAndCompare(dbexpected, hql, params);
    }

    public <T> void retrieveHQLResultsAndCompare(Map<Integer, T> dbexpected, String hql) {
        this.retrieveHQLResultsAndCompare(dbexpected, hql, null);
    }

    protected <T> void retrieveHQLResultsAndCompare(Map<Integer, T> dbexpected, String hql, Map<String, Object> params) {
        HashMap hsreceived = new HashMap();
        this.doInSession(hql, hsreceived, params);
        this.compare(dbexpected, hsreceived);
    }

    private Map<String, Object> createQueryParams(String filterParamName, Object value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(filterParamName, value);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void doInSession(String hql, Map<Integer, T> result, Map<String, Object> params) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            Query query = session.createQuery(hql);
            this.setParameters(params, query);
            this.addQueryResults(result, query);
        }
        finally {
            if (tx != null) {
                tx.rollback();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    private void setParameters(Map<String, Object> params, Query query) {
        if (params == null) {
            return;
        }
        for (String param : params.keySet()) {
            Object value = params.get(param);
            if (value instanceof Geometry) {
                query.setParameter(param, value, (Type)GeometryUserType.TYPE);
                continue;
            }
            query.setParameter(param, value);
        }
    }
}

