/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.testsuite;

import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernatespatial.testsuite.SpatialFunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpatialProjections
extends SpatialFunctionalTestCase {
    private static Logger LOGGER = LoggerFactory.getLogger(TestSpatialProjections.class);

    public TestSpatialProjections(String string) {
        super(string);
    }

    public void prepareTest() {
        super.prepareTest();
        try {
            this.dataSourceUtils.insertTestData(this.testData);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void testProjections() throws Exception {
        this.extent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extent() throws SQLException {
        if (!this.getDialect().getClass().getSimpleName().equals("PostgisDialect")) {
            return;
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            Query query = session.createQuery("select extent(geom) from GeomEntity");
            List result = query.list();
            Polygon pg = (Polygon)result.get(0);
            TestSpatialProjections.assertNotNull((Object)pg);
            TestSpatialProjections.assertEquals((double)0.0, (double)pg.getEnvelopeInternal().getMinX(), (double)1.0E-6);
            TestSpatialProjections.assertEquals((double)0.0, (double)pg.getEnvelopeInternal().getMinY(), (double)1.0E-6);
            TestSpatialProjections.assertEquals((double)150000.0, (double)pg.getEnvelopeInternal().getMaxX(), (double)1.0E-6);
            TestSpatialProjections.assertEquals((double)200000.0, (double)pg.getEnvelopeInternal().getMaxY(), (double)1.0E-6);
        }
        finally {
            if (tx != null) {
                tx.rollback();
            }
            if (session != null) {
                session.close();
            }
        }
    }
}

