/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.testsuite;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernatespatial.SpatialFunction;
import org.hibernatespatial.criterion.SpatialFilter;
import org.hibernatespatial.criterion.SpatialRelateExpression;
import org.hibernatespatial.criterion.SpatialRestrictions;
import org.hibernatespatial.test.GeomEntity;
import org.hibernatespatial.testsuite.SpatialFunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSpatialRestrictions
extends SpatialFunctionalTestCase {
    private static Logger LOGGER = LoggerFactory.getLogger(TestSpatialRestrictions.class);

    public TestSpatialRestrictions(String string) {
        super(string);
    }

    @Override
    public void prepareTest() {
        super.prepareTest();
        try {
            this.dataSourceUtils.insertTestData(this.testData);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public void testRestrictions() throws Exception {
        this.within();
        this.filter();
        this.contains();
        this.crosses();
        this.touches();
        this.disjoint();
        this.eq();
        this.intersects();
        this.overlaps();
        this.dwithin();
        this.havingSRID();
        this.isEmpty();
        this.isNotEmpty();
    }

    public void within() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.within)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getWithin((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.within((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void filter() throws SQLException {
        if (!this.dialectSupportsFiltering()) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getFilter((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialFilter spatialCriterion = SpatialRestrictions.filter((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void contains() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.contains)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getContains((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.contains((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void crosses() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.crosses)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getCrosses((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.crosses((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void touches() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.touches)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getTouches((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.touches((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void disjoint() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.disjoint)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getDisjoint((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.disjoint((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void eq() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.equals)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getEquals((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.eq((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void intersects() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.intersects)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIntersects((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.intersects((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void overlaps() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.overlaps)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getOverlaps((Geometry)this.expectationsFactory.getTestPolygon());
        SpatialRelateExpression spatialCriterion = SpatialRestrictions.overlaps((String)"geom", (Geometry)this.expectationsFactory.getTestPolygon());
        this.retrieveAndCompare(dbexpected, (Criterion)spatialCriterion);
    }

    public void dwithin() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.dwithin)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getDwithin(this.expectationsFactory.getTestPoint(), 30.0);
        Criterion spatialCriterion = SpatialRestrictions.distanceWithin((String)"geom", (Geometry)this.expectationsFactory.getTestPoint(), (double)30.0);
        this.retrieveAndCompare(dbexpected, spatialCriterion);
    }

    public void isEmpty() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.isempty)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIsEmpty();
        Criterion spatialCriterion = SpatialRestrictions.isEmpty((String)"geom");
        this.retrieveAndCompare(dbexpected, spatialCriterion);
    }

    public void isNotEmpty() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.isempty)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.getIsNotEmpty();
        Criterion spatialCriterion = SpatialRestrictions.isNotEmpty((String)"geom");
        this.retrieveAndCompare(dbexpected, spatialCriterion);
    }

    public void havingSRID() throws SQLException {
        if (!this.isSupportedByDialect(SpatialFunction.srid)) {
            return;
        }
        Map dbexpected = this.expectationsFactory.havingSRID(4326);
        Criterion spatialCriterion = SpatialRestrictions.havingSRID((String)"geom", (int)4326);
        this.retrieveAndCompare(dbexpected, spatialCriterion);
        dbexpected = this.expectationsFactory.havingSRID(31370);
        spatialCriterion = SpatialRestrictions.havingSRID((String)"geom", (int)31370);
        this.retrieveAndCompare(dbexpected, spatialCriterion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAndCompare(Map<Integer, Boolean> dbexpected, Criterion spatialCriterion) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(GeomEntity.class);
            criteria.add(spatialCriterion);
            this.compare(dbexpected, criteria.list());
        }
        finally {
            if (tx != null) {
                tx.rollback();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    private void compare(Map<Integer, Boolean> dbexpected, List list) {
        int cnt = 0;
        for (Integer id : dbexpected.keySet()) {
            if (!dbexpected.get(id).booleanValue()) continue;
            ++cnt;
            if (this.findInList(id, list)) continue;
            TestSpatialRestrictions.fail((String)String.format("Expected object with id= %d, but not found in result", id));
        }
        TestSpatialRestrictions.assertEquals((int)cnt, (int)list.size());
        LOGGER.info(String.format("Found %d objects within testsuite-suite polygon.", cnt));
    }

    private boolean findInList(Integer id, List<GeomEntity> list) {
        for (GeomEntity entity : list) {
            if (entity.getId() != id) continue;
            return true;
        }
        return false;
    }
}

