/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.testsuite;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernatespatial.test.GeomEntity;
import org.hibernatespatial.test.TestDataElement;
import org.hibernatespatial.testsuite.SpatialFunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStoreRetrieve
extends SpatialFunctionalTestCase {
    private static Logger LOGGER = LoggerFactory.getLogger(TestStoreRetrieve.class);

    public TestStoreRetrieve(String string) {
        super(string);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public void testStoreRetrieve() throws ParseException {
        HashMap<Integer, GeomEntity> stored = new HashMap<Integer, GeomEntity>();
        this.storeTestObjects(stored);
        this.retrieveAndCompare(stored);
        this.deleteAllTestEntities();
        this.storeNullGeometry();
        this.retrieveNullGeometry();
    }

    private void retrieveAndCompare(Map<Integer, GeomEntity> stored) {
        int id = -1;
        Transaction tx = null;
        Session session = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            for (GeomEntity storedEntity : stored.values()) {
                id = storedEntity.getId();
                GeomEntity retrievedEntity = (GeomEntity)session.get(GeomEntity.class, (Serializable)Integer.valueOf(id));
                Geometry retrievedGeometry = retrievedEntity.getGeom();
                Geometry storedGeometry = storedEntity.getGeom();
                String msg = this.createFailureMessage(storedEntity.getId(), storedGeometry, retrievedGeometry);
                TestStoreRetrieve.assertTrue((String)msg, (boolean)this.geometryEquality.test(storedGeometry, retrievedGeometry));
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException(String.format("Failure on case: %d", id), e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private String createFailureMessage(int id, Geometry storedGeometry, Geometry retrievedGeometry) {
        String expectedText = storedGeometry != null ? storedGeometry.toText() : "NULL";
        String retrievedText = retrievedGeometry != null ? retrievedGeometry.toText() : "NULL";
        return String.format("Equality testsuite-suite failed for %d.\nExpected: %s\nReceived:%s", id, expectedText, retrievedText);
    }

    private void storeTestObjects(Map<Integer, GeomEntity> stored) {
        Session session = null;
        Transaction tx = null;
        int id = -1;
        try {
            session = this.openSession();
            for (TestDataElement element : this.testData) {
                id = element.id;
                tx = session.beginTransaction();
                GeomEntity entity = GeomEntity.createFrom((TestDataElement)element);
                stored.put(entity.getId(), entity);
                session.save((Object)entity);
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException("Failed storing testsuite-suite object with id:" + id, e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void storeNullGeometry() {
        GeomEntity entity = null;
        Session session = null;
        Transaction tx = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            entity = new GeomEntity();
            entity.setId(Integer.valueOf(1));
            entity.setType("NULL OBJECT");
            session.save((Object)entity);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException("Failed storing testsuite-suite object with id:" + entity.getId(), e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void retrieveNullGeometry() {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.openSession();
            tx = session.beginTransaction();
            Criteria criteria = session.createCriteria(GeomEntity.class);
            List retrieved = criteria.list();
            TestStoreRetrieve.assertEquals((String)"Expected exactly one result", (int)1, (int)retrieved.size());
            GeomEntity entity = (GeomEntity)retrieved.get(0);
            TestStoreRetrieve.assertNull((Object)entity.getGeom());
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

